/*
 * Decompiled with CFR 0.152.
 */
package infra.web.server.support;

import infra.context.ApplicationContext;
import infra.http.DefaultHttpHeaders;
import infra.http.HttpCookie;
import infra.http.HttpHeaders;
import infra.http.HttpMethod;
import infra.http.HttpStatusCode;
import infra.http.ResponseCookie;
import infra.http.converter.HttpMessageNotReadableException;
import infra.http.server.ServerHttpResponse;
import infra.http.support.Netty4HttpHeaders;
import infra.lang.Nullable;
import infra.util.CollectionUtils;
import infra.util.MappingMultiValueMap;
import infra.util.MultiValueMap;
import infra.util.StringUtils;
import infra.web.DispatcherHandler;
import infra.web.RequestContext;
import infra.web.RequestContextUtils;
import infra.web.async.AsyncWebRequest;
import infra.web.async.WebAsyncManager;
import infra.web.multipart.MultipartRequest;
import infra.web.server.support.NettyAsyncWebRequest;
import infra.web.server.support.NettyMultipartRequest;
import infra.web.server.support.NettyRequestConfig;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufInputStream;
import io.netty.channel.Channel;
import io.netty.channel.ChannelFutureListener;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.DefaultFileRegion;
import io.netty.channel.FileRegion;
import io.netty.handler.codec.DefaultHeaders;
import io.netty.handler.codec.http.DefaultHttpResponse;
import io.netty.handler.codec.http.DefaultLastHttpContent;
import io.netty.handler.codec.http.FullHttpRequest;
import io.netty.handler.codec.http.HttpMessage;
import io.netty.handler.codec.http.HttpRequest;
import io.netty.handler.codec.http.HttpResponseStatus;
import io.netty.handler.codec.http.HttpUtil;
import io.netty.handler.codec.http.HttpVersion;
import io.netty.handler.codec.http.LastHttpContent;
import io.netty.handler.codec.http.cookie.Cookie;
import io.netty.handler.codec.http.cookie.CookieHeaderNames;
import io.netty.handler.codec.http.cookie.DefaultCookie;
import io.netty.handler.codec.http.cookie.ServerCookieDecoder;
import io.netty.handler.codec.http.cookie.ServerCookieEncoder;
import io.netty.handler.codec.http.multipart.Attribute;
import io.netty.handler.codec.http.multipart.HttpPostMultipartRequestDecoder;
import io.netty.handler.codec.http.multipart.HttpPostStandardRequestDecoder;
import io.netty.handler.codec.http.multipart.InterfaceHttpData;
import io.netty.handler.codec.http.multipart.InterfaceHttpPostRequestDecoder;
import io.netty.util.ReferenceCountUtil;
import io.netty.util.concurrent.GenericFutureListener;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.net.URLDecoder;
import java.nio.charset.StandardCharsets;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.function.Function;

public class NettyRequestContext
extends RequestContext {
    public final NettyRequestConfig config;
    public final ChannelHandlerContext channelContext;
    public final io.netty.handler.codec.http.HttpHeaders nettyResponseHeaders;
    private final FullHttpRequest request;
    private final AtomicBoolean committed = new AtomicBoolean();
    private final long requestTimeMillis = System.currentTimeMillis();
    @Nullable
    private String remoteAddress;
    @Nullable
    private InterfaceHttpPostRequestDecoder requestDecoder;
    @Nullable
    private Boolean keepAlive;
    private HttpResponseStatus status = HttpResponseStatus.OK;
    @Nullable
    private ByteBuf responseBody;
    @Nullable
    private FileRegion fileToSend;
    @Nullable
    private Integer queryStringIndex;
    @Nullable
    private InetSocketAddress inetSocketAddress;

    protected NettyRequestContext(ApplicationContext context, ChannelHandlerContext ctx, FullHttpRequest request, NettyRequestConfig config, DispatcherHandler dispatcherHandler) {
        super(context, dispatcherHandler);
        this.config = config;
        this.request = request;
        this.channelContext = ctx;
        this.nettyResponseHeaders = config.httpHeadersFactory.newHeaders();
    }

    @Override
    public long getRequestTimeMillis() {
        return this.requestTimeMillis;
    }

    @Override
    public String getScheme() {
        return this.config.secure ? "https" : "http";
    }

    private InetSocketAddress localAddress() {
        InetSocketAddress inetSocketAddress = this.inetSocketAddress;
        if (inetSocketAddress == null) {
            InetSocketAddress address;
            SocketAddress socketAddress = this.channelContext.channel().localAddress();
            inetSocketAddress = socketAddress instanceof InetSocketAddress ? (address = (InetSocketAddress)socketAddress) : new InetSocketAddress("localhost", 8080);
            this.inetSocketAddress = inetSocketAddress;
        }
        return inetSocketAddress;
    }

    @Override
    public int getServerPort() {
        return this.localAddress().getPort();
    }

    @Override
    public String getServerName() {
        return this.localAddress().getHostString();
    }

    @Override
    protected final String doGetRequestURI() {
        String uri = this.request.uri();
        int index = this.queryStringIndex(uri);
        if (index == -1) {
            return uri;
        }
        return uri.substring(0, index);
    }

    @Override
    public final String doGetQueryString() {
        String uri = this.request.uri();
        int index = this.queryStringIndex(uri);
        if (index == -1) {
            return "";
        }
        return uri.substring(index + 1);
    }

    private int queryStringIndex(String uri) {
        Integer index = this.queryStringIndex;
        if (index == null) {
            this.queryStringIndex = index = Integer.valueOf(uri.indexOf(63));
        }
        return index;
    }

    @Override
    public String getRequestURL() {
        String host = this.request.headers().get("Host");
        if (host == null) {
            host = "localhost";
        }
        return this.getScheme() + "://" + host + StringUtils.prependLeadingSlash((String)this.getRequestURI());
    }

    @Override
    public final String getRemoteAddress() {
        if (this.remoteAddress == null) {
            InetSocketAddress remote = (InetSocketAddress)this.channelContext.channel().remoteAddress();
            this.remoteAddress = remote.getAddress().getHostAddress();
        }
        return this.remoteAddress;
    }

    @Override
    public final String doGetMethod() {
        return this.request.method().name();
    }

    @Override
    protected PrintWriter doGetWriter() throws IOException {
        return new PrintWriter(this.getOutputStream(), true, this.config.writerCharset);
    }

    @Override
    protected InputStream doGetInputStream() {
        return new ByteBufInputStream(this.request.content());
    }

    @Override
    protected HttpHeaders createRequestHeaders() {
        io.netty.handler.codec.http.HttpHeaders headers = this.request.headers();
        DefaultHttpHeaders ret = new DefaultHttpHeaders();
        for (Map.Entry header : headers) {
            ret.add((String)header.getKey(), (String)header.getValue());
        }
        return ret;
    }

    @Override
    public String getContentType() {
        return this.request.headers().get("Content-Type");
    }

    @Override
    public boolean containsResponseHeader(String name) {
        return this.nettyResponseHeaders.contains(name);
    }

    @Override
    @Nullable
    public String getResponseContentType() {
        String contentType = this.responseContentType;
        if (contentType == null && (contentType = this.nettyResponseHeaders.get("Content-Type")) != null) {
            this.responseContentType = contentType;
        }
        return contentType;
    }

    @Override
    protected HttpHeaders createResponseHeaders() {
        return new Netty4HttpHeaders(this.nettyResponseHeaders);
    }

    @Override
    public HttpCookie[] doGetCookies() {
        Set decoded;
        List allCookie = this.request.headers().getAll("Cookie");
        if (CollectionUtils.isEmpty((Collection)allCookie)) {
            return EMPTY_COOKIES;
        }
        ServerCookieDecoder cookieDecoder = this.config.cookieDecoder;
        if (allCookie.size() == 1) {
            decoded = cookieDecoder.decode((String)allCookie.get(0));
        } else {
            decoded = new TreeSet();
            for (String header : allCookie) {
                decoded.addAll(cookieDecoder.decode(header));
            }
        }
        if (CollectionUtils.isEmpty(decoded)) {
            return EMPTY_COOKIES;
        }
        int i = 0;
        HttpCookie[] ret = new HttpCookie[decoded.size()];
        for (Cookie cookie : decoded) {
            ret[i++] = new HttpCookie(cookie.name(), cookie.value());
        }
        return ret;
    }

    @Override
    protected MultiValueMap<String, String> doGetParameters() {
        String queryString = URLDecoder.decode(this.getQueryString(), StandardCharsets.UTF_8);
        MappingMultiValueMap parameters = MultiValueMap.forSmartListAdaption(new LinkedHashMap());
        RequestContextUtils.parseParameters((MultiValueMap<String, String>)parameters, queryString);
        HttpMethod method = this.getMethod();
        if (method != HttpMethod.GET && method != HttpMethod.HEAD && StringUtils.startsWithIgnoreCase((String)this.getContentType(), (String)"application/x-www-form-urlencoded")) {
            for (InterfaceHttpData data : this.requestDecoder().getBodyHttpDatas()) {
                if (!(data instanceof Attribute)) continue;
                try {
                    parameters.add((Object)data.getName(), (Object)((Attribute)data).getValue());
                }
                catch (IOException e) {
                    throw new HttpMessageNotReadableException("'application/x-www-form-urlencoded' content read failed", e, this);
                }
            }
        }
        return parameters;
    }

    InterfaceHttpPostRequestDecoder requestDecoder() {
        Object requestDecoder = this.requestDecoder;
        if (requestDecoder == null) {
            requestDecoder = this.isMultipart() ? new HttpPostMultipartRequestDecoder(this.config.httpDataFactory, (HttpRequest)this.request, this.config.postRequestDecoderCharset) : new HttpPostStandardRequestDecoder(this.config.httpDataFactory, (HttpRequest)this.request, this.config.postRequestDecoderCharset);
            requestDecoder.setDiscardThreshold(0);
            this.requestDecoder = requestDecoder;
        }
        return requestDecoder;
    }

    @Override
    public long getContentLength() {
        return this.request.content().readableBytes();
    }

    @Override
    public void sendRedirect(String location) {
        this.status = HttpResponseStatus.FOUND;
        this.nettyResponseHeaders.set("Location", (Object)location);
        this.commit();
    }

    private boolean isKeepAlive() {
        Boolean keepAlive = this.keepAlive;
        if (keepAlive == null) {
            this.keepAlive = keepAlive = Boolean.valueOf(HttpUtil.isKeepAlive((HttpMessage)this.request));
        }
        return keepAlive;
    }

    public final ByteBuf responseBody() {
        ByteBuf responseBody = this.responseBody;
        if (responseBody == null) {
            Function<RequestContext, ByteBuf> bodyFactory = this.config.responseBodyFactory;
            if (bodyFactory != null) {
                responseBody = bodyFactory.apply(this);
            }
            if (responseBody == null) {
                responseBody = this.createResponseBody(this.channelContext.channel(), this.config);
            }
            this.responseBody = responseBody;
        }
        return responseBody;
    }

    protected ByteBuf createResponseBody(Channel channel, NettyRequestConfig config) {
        return channel.alloc().ioBuffer(config.responseBodyInitialCapacity);
    }

    @Override
    public ServerHttpResponse asHttpOutputMessage() {
        return new NettyHttpOutputMessage();
    }

    @Override
    public void flush() {
        this.writeHeaders();
        ByteBuf responseBody = this.responseBody;
        if (responseBody != null) {
            this.responseBody = null;
            this.channelContext.writeAndFlush((Object)responseBody);
        } else {
            FileRegion fileToSend = this.fileToSend;
            if (fileToSend != null) {
                this.channelContext.writeAndFlush((Object)fileToSend);
            }
        }
    }

    @Override
    protected OutputStream doGetOutputStream() {
        return this.getMethod() == HttpMethod.HEAD ? new NoBodyOutputStream() : new ResponseBodyOutputStream();
    }

    @Override
    protected void requestCompletedInternal(@Nullable Throwable notHandled) {
        String declaredHeaderNames;
        int cnt = this.request.refCnt();
        if (cnt != 0) {
            ReferenceCountUtil.safeRelease((Object)this.request);
        }
        if (this.requestDecoder != null) {
            this.requestDecoder.destroy();
        }
        if (notHandled != null) {
            return;
        }
        this.flush();
        LastHttpContent lastHttpContent = LastHttpContent.EMPTY_LAST_CONTENT;
        if (this.config.trailerHeadersConsumer != null && NettyRequestContext.isTransferEncodingChunked(this.nettyResponseHeaders) && (declaredHeaderNames = this.nettyResponseHeaders.get("Trailer")) != null) {
            TrailerHeaders trailerHeaders = new TrailerHeaders(declaredHeaderNames);
            try {
                this.config.trailerHeadersConsumer.accept((io.netty.handler.codec.http.HttpHeaders)trailerHeaders);
            }
            catch (IllegalArgumentException illegalArgumentException) {
                // empty catch block
            }
            if (!trailerHeaders.isEmpty()) {
                lastHttpContent = new DefaultLastHttpContent();
                lastHttpContent.trailingHeaders().set((io.netty.handler.codec.http.HttpHeaders)trailerHeaders);
            }
        }
        if (this.isKeepAlive()) {
            this.channelContext.writeAndFlush((Object)lastHttpContent);
        } else {
            this.channelContext.writeAndFlush((Object)lastHttpContent).addListener((GenericFutureListener)ChannelFutureListener.CLOSE);
        }
    }

    private void commit() {
        this.assertNotCommitted();
        this.writeHeaders();
    }

    @Override
    protected void writeHeaders() {
        if (this.committed.compareAndSet(false, true)) {
            ArrayList responseCookies;
            io.netty.handler.codec.http.HttpHeaders headers = this.nettyResponseHeaders;
            if (this.status != HttpResponseStatus.SWITCHING_PROTOCOLS) {
                if ("text/event-stream".equals(this.getResponseContentType())) {
                    headers.set("Transfer-Encoding", (Object)"chunked");
                    headers.remove("Content-Length");
                } else if (!NettyRequestContext.isTransferEncodingChunked(headers) && headers.get("Content-Length") == null) {
                    ByteBuf responseBody = this.responseBody;
                    if (responseBody == null) {
                        Object object;
                        if (this.getMethod() == HttpMethod.HEAD && (object = this.outputStream) instanceof NoBodyOutputStream) {
                            NoBodyOutputStream nbStream = (NoBodyOutputStream)object;
                            headers.set("Content-Length", (Object)nbStream.contentLength);
                        } else {
                            headers.setInt((CharSequence)"Content-Length", 0);
                        }
                    } else {
                        headers.setInt((CharSequence)"Content-Length", responseBody.readableBytes());
                    }
                }
            }
            if ((responseCookies = this.responseCookies) != null) {
                ServerCookieEncoder cookieEncoder = this.config.cookieEncoder;
                for (HttpCookie cookie : responseCookies) {
                    DefaultCookie nc = new DefaultCookie(cookie.getName(), cookie.getValue());
                    if (cookie instanceof ResponseCookie) {
                        ResponseCookie rc = (ResponseCookie)cookie;
                        nc.setPath(rc.getPath());
                        nc.setDomain(rc.getDomain());
                        nc.setMaxAge(rc.getMaxAge().getSeconds());
                        nc.setSecure(rc.isSecure());
                        nc.setHttpOnly(rc.isHttpOnly());
                        nc.setSameSite(NettyRequestContext.forSameSite(rc.getSameSite()));
                        nc.setPartitioned(rc.isPartitioned());
                    }
                    headers.add("Set-Cookie", (Object)cookieEncoder.encode((Cookie)nc));
                }
            }
            this.channelContext.write((Object)new DefaultHttpResponse(HttpVersion.HTTP_1_1, this.status, headers));
        }
    }

    @Override
    public void setContentLength(long length) {
        this.nettyResponseHeaders.set("Content-Length", (Object)length);
    }

    @Override
    public boolean isCommitted() {
        return this.committed.get();
    }

    @Override
    public void reset() {
        this.assertNotCommitted();
        this.nettyResponseHeaders.clear();
        ByteBuf responseBody = this.responseBody;
        if (responseBody != null) {
            responseBody.resetWriterIndex();
            responseBody.resetReaderIndex();
            this.writer = null;
        }
        this.status = HttpResponseStatus.OK;
    }

    private void assertNotCommitted() {
        if (this.committed.get()) {
            throw new IllegalStateException("The response has been committed");
        }
    }

    @Override
    public void setStatus(int sc) {
        this.status = HttpResponseStatus.valueOf((int)sc);
    }

    @Override
    public void setStatus(HttpStatusCode status) {
        this.status = HttpResponseStatus.valueOf((int)status.value());
    }

    public void setStatus(HttpResponseStatus status) {
        this.status = status;
    }

    @Override
    public int getStatus() {
        return this.status.code();
    }

    @Override
    public void sendError(int sc) throws IOException {
        this.sendError(sc, null);
    }

    @Override
    public void sendError(int sc, @Nullable String msg) throws IOException {
        this.reset();
        this.status = HttpResponseStatus.valueOf((int)sc);
        this.config.sendErrorHandler.handleError(this, msg);
    }

    public final FullHttpRequest nativeRequest() {
        return this.request;
    }

    @Override
    protected MultipartRequest createMultipartRequest() {
        return new NettyMultipartRequest(this);
    }

    @Override
    protected AsyncWebRequest createAsyncWebRequest() {
        return new NettyAsyncWebRequest(this);
    }

    void dispatchConcurrentResult(@Nullable Object concurrentResult) throws Throwable {
        Object handler = WebAsyncManager.findHttpRequestHandler(this);
        this.dispatcherHandler.handleConcurrentResult(this, handler, concurrentResult);
    }

    @Nullable
    static CookieHeaderNames.SameSite forSameSite(@Nullable String name) {
        if (name != null) {
            for (CookieHeaderNames.SameSite each : (CookieHeaderNames.SameSite[])CookieHeaderNames.SameSite.class.getEnumConstants()) {
                if (!each.name().equalsIgnoreCase(name)) continue;
                return each;
            }
        }
        return null;
    }

    private static boolean isTransferEncodingChunked(io.netty.handler.codec.http.HttpHeaders responseHeaders) {
        return responseHeaders.containsValue((CharSequence)"Transfer-Encoding", (CharSequence)"chunked", true);
    }

    final class NettyHttpOutputMessage
    implements ServerHttpResponse {
        NettyHttpOutputMessage() {
        }

        @Override
        public void setStatusCode(HttpStatusCode status) {
            NettyRequestContext.this.setStatus(status);
        }

        @Override
        public void flush() {
            NettyRequestContext.this.flush();
        }

        @Override
        public void close() {
            NettyRequestContext.this.writeHeaders();
        }

        @Override
        public OutputStream getBody() throws IOException {
            return NettyRequestContext.this.getOutputStream();
        }

        @Override
        public HttpHeaders getHeaders() {
            return NettyRequestContext.this.responseHeaders();
        }

        @Override
        public boolean supportsZeroCopy() {
            return !NettyRequestContext.this.config.secure;
        }

        @Override
        public void sendFile(Path file, long position, long count) {
            this.sendFile(file.toFile(), position, count);
        }

        @Override
        public void sendFile(File file, long position, long count) {
            NettyRequestContext.this.fileToSend = new DefaultFileRegion(file, position, count);
        }
    }

    static final class NoBodyOutputStream
    extends OutputStream {
        public int contentLength = 0;

        NoBodyOutputStream() {
        }

        @Override
        public void write(int b) {
            ++this.contentLength;
        }

        @Override
        public void write(byte[] buf, int offset, int len) {
            if (offset < 0 || len < 0 || offset + len > buf.length) {
                throw new IndexOutOfBoundsException("Invalid offset [%s] and / or length [%s] specified for array of size [%s]".formatted(offset, len, buf.length));
            }
            this.contentLength += len;
        }
    }

    final class ResponseBodyOutputStream
    extends OutputStream {
        ResponseBodyOutputStream() {
        }

        @Override
        public void write(int b) {
            NettyRequestContext.this.responseBody().writeByte(b);
        }

        @Override
        public void write(byte[] b, int off, int len) {
            if (len != 0) {
                NettyRequestContext.this.responseBody().writeBytes(b, off, len);
            }
        }

        @Override
        public void flush() {
            NettyRequestContext.this.flush();
        }
    }

    private static final class TrailerHeaders
    extends io.netty.handler.codec.http.DefaultHttpHeaders {
        static final HashSet<String> DISALLOWED_TRAILER_HEADER_NAMES = new HashSet(14);

        TrailerHeaders(String declaredHeaderNames) {
            super(true, (DefaultHeaders.NameValidator)new TrailerNameValidator(TrailerHeaders.filterHeaderNames(declaredHeaderNames)));
        }

        static HashSet<String> filterHeaderNames(String declaredHeaderNames) {
            String[] names;
            HashSet<String> result = new HashSet<String>();
            for (String name : names = declaredHeaderNames.split(",", -1)) {
                String trimmedStr = name.trim();
                if (trimmedStr.isEmpty() || DISALLOWED_TRAILER_HEADER_NAMES.contains(trimmedStr.toLowerCase(Locale.ENGLISH))) continue;
                result.add(trimmedStr);
            }
            return result;
        }

        static {
            DISALLOWED_TRAILER_HEADER_NAMES.add("age");
            DISALLOWED_TRAILER_HEADER_NAMES.add("cache-control");
            DISALLOWED_TRAILER_HEADER_NAMES.add("content-encoding");
            DISALLOWED_TRAILER_HEADER_NAMES.add("content-length");
            DISALLOWED_TRAILER_HEADER_NAMES.add("content-range");
            DISALLOWED_TRAILER_HEADER_NAMES.add("content-type");
            DISALLOWED_TRAILER_HEADER_NAMES.add("date");
            DISALLOWED_TRAILER_HEADER_NAMES.add("expires");
            DISALLOWED_TRAILER_HEADER_NAMES.add("location");
            DISALLOWED_TRAILER_HEADER_NAMES.add("retry-after");
            DISALLOWED_TRAILER_HEADER_NAMES.add("trailer");
            DISALLOWED_TRAILER_HEADER_NAMES.add("transfer-encoding");
            DISALLOWED_TRAILER_HEADER_NAMES.add("vary");
            DISALLOWED_TRAILER_HEADER_NAMES.add("warning");
        }
    }

    static final class TrailerNameValidator
    implements DefaultHeaders.NameValidator<CharSequence> {
        final HashSet<String> declaredHeaderNames;

        TrailerNameValidator(HashSet<String> declaredHeaderNames) {
            this.declaredHeaderNames = declaredHeaderNames;
        }

        public void validateName(CharSequence name) {
            if (!this.declaredHeaderNames.contains(name.toString())) {
                throw new IllegalArgumentException("Trailer header name [%s] not declared with [Trailer] header, or it is not a valid trailer header name".formatted(name));
            }
        }
    }
}

