/*
 * Decompiled with CFR 0.152.
 */
package infra.web.server.support;

import infra.lang.Assert;
import infra.lang.Constant;
import infra.lang.Nullable;
import infra.web.RequestContext;
import infra.web.server.error.SendErrorHandler;
import io.netty.buffer.ByteBuf;
import io.netty.handler.codec.http.DefaultHttpHeadersFactory;
import io.netty.handler.codec.http.HttpHeaders;
import io.netty.handler.codec.http.HttpHeadersFactory;
import io.netty.handler.codec.http.cookie.ServerCookieDecoder;
import io.netty.handler.codec.http.cookie.ServerCookieEncoder;
import io.netty.handler.codec.http.multipart.HttpDataFactory;
import java.nio.charset.Charset;
import java.util.function.Consumer;
import java.util.function.Function;

public class NettyRequestConfig {
    @Nullable
    public final Consumer<? super HttpHeaders> trailerHeadersConsumer;
    public final ServerCookieEncoder cookieEncoder;
    public final ServerCookieDecoder cookieDecoder;
    public final int responseBodyInitialCapacity;
    @Nullable
    public final Function<RequestContext, ByteBuf> responseBodyFactory;
    public final Charset postRequestDecoderCharset;
    public final Charset writerCharset;
    public final HttpHeadersFactory httpHeadersFactory;
    public final HttpDataFactory httpDataFactory;
    public final SendErrorHandler sendErrorHandler;
    public final boolean secure;

    private NettyRequestConfig(Builder builder) {
        Assert.notNull((Object)builder.sendErrorHandler, (String)"SendErrorHandler is required");
        Assert.notNull((Object)builder.httpDataFactory, (String)"HttpDataFactory is required");
        Assert.isTrue((builder.responseBodyInitialCapacity > 0 ? 1 : 0) != 0, (String)"responseBodyInitialCapacity is required");
        this.secure = builder.secure;
        this.cookieEncoder = builder.cookieEncoder;
        this.cookieDecoder = builder.cookieDecoder;
        this.httpDataFactory = builder.httpDataFactory;
        this.sendErrorHandler = builder.sendErrorHandler;
        this.httpHeadersFactory = builder.httpHeadersFactory;
        this.responseBodyFactory = builder.responseBodyFactory;
        this.trailerHeadersConsumer = builder.trailerHeadersConsumer;
        this.responseBodyInitialCapacity = builder.responseBodyInitialCapacity;
        this.postRequestDecoderCharset = builder.postRequestDecoderCharset == null ? Constant.DEFAULT_CHARSET : builder.postRequestDecoderCharset;
        this.writerCharset = builder.writerCharset == null ? Constant.DEFAULT_CHARSET : builder.writerCharset;
    }

    public static Builder forBuilder(boolean secure) {
        return new Builder(secure);
    }

    public static class Builder {
        @Nullable
        private Consumer<? super HttpHeaders> trailerHeadersConsumer;
        private ServerCookieEncoder cookieEncoder = ServerCookieEncoder.STRICT;
        private ServerCookieDecoder cookieDecoder = ServerCookieDecoder.STRICT;
        private int responseBodyInitialCapacity = 128;
        @Nullable
        private Function<RequestContext, ByteBuf> responseBodyFactory;
        @Nullable
        private Charset postRequestDecoderCharset = Constant.DEFAULT_CHARSET;
        @Nullable
        private Charset writerCharset = Constant.DEFAULT_CHARSET;
        private HttpHeadersFactory httpHeadersFactory = DefaultHttpHeadersFactory.headersFactory();
        private HttpDataFactory httpDataFactory;
        private SendErrorHandler sendErrorHandler;
        private final boolean secure;

        Builder(boolean secure) {
            this.secure = secure;
        }

        public Builder sendErrorHandler(SendErrorHandler sendErrorHandler) {
            this.sendErrorHandler = sendErrorHandler;
            return this;
        }

        public Builder httpDataFactory(HttpDataFactory httpDataFactory) {
            this.httpDataFactory = httpDataFactory;
            return this;
        }

        public Builder trailerHeadersConsumer(@Nullable Consumer<? super HttpHeaders> consumer) {
            this.trailerHeadersConsumer = consumer;
            return this;
        }

        public Builder cookieDecoder(@Nullable ServerCookieDecoder cookieDecoder) {
            this.cookieDecoder = cookieDecoder == null ? ServerCookieDecoder.STRICT : cookieDecoder;
            return this;
        }

        public Builder cookieEncoder(@Nullable ServerCookieEncoder cookieEncoder) {
            this.cookieEncoder = cookieEncoder == null ? ServerCookieEncoder.STRICT : cookieEncoder;
            return this;
        }

        public Builder responseBodyFactory(@Nullable Function<RequestContext, ByteBuf> factory) {
            this.responseBodyFactory = factory;
            return this;
        }

        public Builder responseBodyInitialCapacity(int responseBodyInitialCapacity) {
            this.responseBodyInitialCapacity = responseBodyInitialCapacity;
            return this;
        }

        public Builder postRequestDecoderCharset(@Nullable Charset charset) {
            this.postRequestDecoderCharset = charset == null ? Constant.DEFAULT_CHARSET : charset;
            return this;
        }

        public Builder writerCharset(@Nullable Charset charset) {
            this.writerCharset = charset == null ? Constant.DEFAULT_CHARSET : charset;
            return this;
        }

        public Builder headersFactory(@Nullable HttpHeadersFactory headersFactory) {
            this.httpHeadersFactory = headersFactory == null ? DefaultHttpHeadersFactory.headersFactory() : headersFactory;
            return this;
        }

        public NettyRequestConfig build() {
            return new NettyRequestConfig(this);
        }
    }
}

