/*
 * Decompiled with CFR 0.152.
 */
package infra.web.server.support;

import infra.http.DefaultHttpHeaders;
import infra.http.HttpHeaders;
import infra.util.LinkedMultiValueMap;
import infra.util.MultiValueMap;
import infra.web.bind.NotMultipartRequestException;
import infra.web.multipart.MaxUploadSizeExceededException;
import infra.web.multipart.Multipart;
import infra.web.multipart.support.AbstractMultipartRequest;
import infra.web.server.support.NettyFormData;
import infra.web.server.support.NettyMultipartFile;
import infra.web.server.support.NettyRequestContext;
import io.netty.handler.codec.http.multipart.Attribute;
import io.netty.handler.codec.http.multipart.FileUpload;
import io.netty.handler.codec.http.multipart.HttpPostRequestDecoder;
import io.netty.handler.codec.http.multipart.InterfaceHttpData;
import java.util.List;

final class NettyMultipartRequest
extends AbstractMultipartRequest {
    private final NettyRequestContext context;

    public NettyMultipartRequest(NettyRequestContext context) {
        this.context = context;
    }

    @Override
    public HttpHeaders getMultipartHeaders(String paramOrFileName) {
        List bodyHttpDatas = this.context.requestDecoder().getBodyHttpDatas(paramOrFileName);
        if (bodyHttpDatas != null) {
            DefaultHttpHeaders headers = HttpHeaders.forWritable();
            for (InterfaceHttpData bodyHttpData : bodyHttpDatas) {
                if (!(bodyHttpData instanceof FileUpload)) continue;
                FileUpload httpData = (FileUpload)bodyHttpData;
                String contentType = httpData.getContentType();
                headers.setOrRemove("Content-Type", contentType);
                break;
            }
            return headers;
        }
        return null;
    }

    @Override
    protected MultiValueMap<String, Multipart> parseRequest() {
        LinkedMultiValueMap map = MultiValueMap.forLinkedHashMap();
        try {
            for (InterfaceHttpData data : this.context.requestDecoder().getBodyHttpDatas()) {
                if (data instanceof FileUpload) {
                    FileUpload fileUpload = (FileUpload)data;
                    map.add((Object)data.getName(), (Object)new NettyMultipartFile(fileUpload));
                    continue;
                }
                if (!(data instanceof Attribute)) continue;
                Attribute attribute = (Attribute)data;
                NettyFormData nettyFormData = new NettyFormData(attribute);
                map.add((Object)attribute.getName(), (Object)nettyFormData);
            }
            return map;
        }
        catch (HttpPostRequestDecoder.TooLongFormFieldException e) {
            throw new MaxUploadSizeExceededException(-1L, (Throwable)e);
        }
        catch (HttpPostRequestDecoder.NotEnoughDataDecoderException e) {
            throw new NotMultipartRequestException("Not enough data", e);
        }
    }
}

