/*
 * Decompiled with CFR 0.152.
 */
package infra.web.server.support;

import infra.web.multipart.MultipartFile;
import infra.web.multipart.support.AbstractMultipartFile;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufInputStream;
import io.netty.handler.codec.http.multipart.FileUpload;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.channels.FileChannel;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.StandardOpenOption;

final class NettyMultipartFile
extends AbstractMultipartFile
implements MultipartFile {
    private final FileUpload fileUpload;

    public NettyMultipartFile(FileUpload fileUpload) {
        this.fileUpload = fileUpload;
    }

    public InputStream getInputStream() throws IOException {
        if (this.fileUpload.isInMemory()) {
            ByteBuf byteBuf = this.fileUpload.getByteBuf();
            byteBuf.resetReaderIndex();
            return new ByteBufInputStream(byteBuf);
        }
        return new FileInputStream(this.fileUpload.getFile());
    }

    @Override
    public String getContentType() {
        return this.fileUpload.getContentType();
    }

    @Override
    public long getSize() {
        return this.fileUpload.length();
    }

    @Override
    public String getName() {
        return this.fileUpload.getName();
    }

    @Override
    public String getOriginalFilename() {
        return this.fileUpload.getFilename();
    }

    @Override
    protected void saveInternal(File dest) throws IOException {
        this.fileUpload.renameTo(dest);
    }

    public long transferTo(OutputStream out) throws IOException {
        if (this.fileUpload.isInMemory()) {
            ByteBuf byteBuf = this.fileUpload.getByteBuf();
            int length = byteBuf.readableBytes();
            byteBuf.readBytes(out, length);
            return length;
        }
        try (FileInputStream in = new FileInputStream(this.fileUpload.getFile());){
            long l = in.transferTo(out);
            return l;
        }
    }

    @Override
    public long transferTo(FileChannel out, long position, long count) throws IOException {
        if (this.fileUpload.isInMemory()) {
            return this.fileUpload.getByteBuf().readBytes(out, position, Math.toIntExact(count));
        }
        try (FileChannel src = FileChannel.open(this.fileUpload.getFile().toPath(), new OpenOption[0]);){
            long l = out.transferFrom(src, position, count);
            return l;
        }
    }

    @Override
    public void transferTo(Path dest) throws IOException, IllegalStateException {
        try (FileChannel channel = FileChannel.open(dest, StandardOpenOption.CREATE, StandardOpenOption.WRITE);){
            this.transferTo(channel, 0L, this.fileUpload.length());
        }
    }

    @Override
    public boolean isEmpty() {
        return this.getSize() == 0L;
    }

    @Override
    protected byte[] doGetBytes() throws IOException {
        return this.fileUpload.get();
    }

    @Override
    public Object getOriginalResource() {
        return this.fileUpload;
    }

    @Override
    protected void deleteInternal() {
        this.fileUpload.delete();
    }
}

