/*
 * Decompiled with CFR 0.152.
 */
package infra.web.server.support;

import infra.lang.Assert;
import infra.lang.Nullable;
import infra.web.server.support.ChannelConfigurer;
import io.netty.channel.Channel;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelInitializer;
import io.netty.handler.codec.http.HttpDecoderConfig;
import io.netty.handler.codec.http.HttpObjectAggregator;
import io.netty.handler.codec.http.HttpServerCodec;
import io.netty.handler.codec.http.HttpServerExpectContinueHandler;

/*
 * Uses 'sealed' constructs - enablewith --sealed true
 */
class NettyChannelInitializer
extends ChannelInitializer<Channel>
implements ChannelHandler {
    private final ChannelHandler nettyChannelHandler;
    @Nullable
    private final ChannelConfigurer channelConfigurer;
    private int maxContentLength = 0x4000000;
    private boolean closeOnExpectationFailed = false;
    private HttpDecoderConfig httpDecoderConfig = new HttpDecoderConfig().setMaxInitialLineLength(4096).setMaxHeaderSize(8192).setMaxChunkSize(8192).setValidateHeaders(true);

    protected NettyChannelInitializer(ChannelHandler channelHandler, @Nullable ChannelConfigurer channelConfigurer) {
        this.nettyChannelHandler = channelHandler;
        this.channelConfigurer = channelConfigurer;
    }

    protected final void initChannel(Channel ch) {
        this.preInitChannel(this.channelConfigurer, ch);
        ch.pipeline().addLast("HttpServerCodec", (ChannelHandler)new HttpServerCodec(this.httpDecoderConfig)).addLast("HttpObjectAggregator", (ChannelHandler)new HttpObjectAggregator(this.maxContentLength, this.closeOnExpectationFailed)).addLast("HttpServerExpectContinueHandler", (ChannelHandler)new HttpServerExpectContinueHandler()).addLast("NettyChannelHandler", this.nettyChannelHandler).remove((ChannelHandler)this);
    }

    protected void preInitChannel(@Nullable ChannelConfigurer configurer, Channel ch) {
        if (configurer != null) {
            configurer.initChannel(ch);
        }
    }

    public boolean isSharable() {
        return true;
    }

    public void setHttpDecoderConfig(HttpDecoderConfig httpDecoderConfig) {
        Assert.notNull((Object)httpDecoderConfig, (String)"HttpDecoderConfig is required");
        this.httpDecoderConfig = httpDecoderConfig;
    }

    public void setMaxContentLength(int maxContentLength) {
        this.maxContentLength = maxContentLength;
    }

    public void setCloseOnExpectationFailed(boolean closeOnExpectationFailed) {
        this.closeOnExpectationFailed = closeOnExpectationFailed;
    }
}

