/*
 * Decompiled with CFR 0.152.
 */
package infra.web.server.support;

import infra.beans.factory.SmartInitializingSingleton;
import infra.context.ApplicationContext;
import infra.core.Pair;
import infra.core.env.ConfigurableEnvironment;
import infra.http.HttpStatusCode;
import infra.lang.Assert;
import infra.lang.Nullable;
import infra.web.DispatcherHandler;
import infra.web.HttpStatusProvider;
import infra.web.RequestContextHolder;
import infra.web.server.support.NettyRequestConfig;
import infra.web.server.support.NettyRequestContext;
import infra.web.server.support.StandardNettyWebEnvironment;
import io.netty.buffer.Unpooled;
import io.netty.channel.ChannelFutureListener;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelInboundHandler;
import io.netty.handler.codec.http.DefaultFullHttpResponse;
import io.netty.handler.codec.http.DefaultHttpHeadersFactory;
import io.netty.handler.codec.http.FullHttpRequest;
import io.netty.handler.codec.http.HttpHeadersFactory;
import io.netty.handler.codec.http.HttpResponse;
import io.netty.handler.codec.http.HttpResponseStatus;
import io.netty.handler.codec.http.HttpVersion;
import io.netty.handler.codec.http.websocketx.WebSocketFrame;
import io.netty.util.ReferenceCountUtil;
import io.netty.util.concurrent.GenericFutureListener;

public class NettyChannelHandler
extends DispatcherHandler
implements ChannelInboundHandler,
SmartInitializingSingleton {
    protected final NettyRequestConfig requestConfig;

    public NettyChannelHandler(NettyRequestConfig requestConfig, ApplicationContext context) {
        super(context);
        Assert.notNull((Object)context, (String)"ApplicationContext is required");
        Assert.notNull((Object)requestConfig, (String)"NettyRequestConfig is required");
        this.requestConfig = requestConfig;
    }

    public void afterSingletonsInstantiated() {
        this.init();
    }

    @Override
    protected ConfigurableEnvironment createEnvironment() {
        return new StandardNettyWebEnvironment();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void channelRead(ChannelHandlerContext ctx, Object msg) {
        if (msg instanceof FullHttpRequest) {
            FullHttpRequest request = (FullHttpRequest)msg;
            NettyRequestContext nettyContext = this.createContext(ctx, request);
            RequestContextHolder.set(nettyContext);
            try {
                this.handleRequest(nettyContext);
            }
            catch (Throwable e) {
                this.exceptionCaught(ctx, e);
            }
            finally {
                RequestContextHolder.cleanup();
            }
        } else if (msg instanceof WebSocketFrame) {
            this.handleWebSocketFrame(ctx, (WebSocketFrame)msg);
            ReferenceCountUtil.safeRelease((Object)msg);
        } else {
            ctx.fireChannelRead(msg);
        }
    }

    protected void handleWebSocketFrame(ChannelHandlerContext ctx, WebSocketFrame frame) {
        ctx.fireChannelRead((Object)frame);
    }

    protected NettyRequestContext createContext(ChannelHandlerContext ctx, FullHttpRequest httpRequest) {
        return new NettyRequestContext(this.getApplicationContext(), ctx, httpRequest, this.requestConfig, this);
    }

    public void exceptionCaught(ChannelHandlerContext ctx, Throwable cause) {
        HttpResponse response = this.createErrorResponse(ctx, cause);
        if (response != null) {
            ctx.writeAndFlush((Object)response).addListener((GenericFutureListener)ChannelFutureListener.CLOSE);
        }
    }

    @Nullable
    protected HttpResponse createErrorResponse(ChannelHandlerContext ctx, Throwable cause) {
        Pair<HttpStatusCode, String> statusCode = HttpStatusProvider.getStatusCode(cause);
        return new DefaultFullHttpResponse(HttpVersion.HTTP_1_1, HttpResponseStatus.valueOf((int)((HttpStatusCode)statusCode.first).value()), Unpooled.EMPTY_BUFFER, this.requestConfig.httpHeadersFactory, (HttpHeadersFactory)DefaultHttpHeadersFactory.trailersFactory());
    }

    public void handlerAdded(ChannelHandlerContext ctx) {
    }

    public void handlerRemoved(ChannelHandlerContext ctx) {
    }

    public void channelRegistered(ChannelHandlerContext ctx) {
        ctx.fireChannelRegistered();
    }

    public void channelUnregistered(ChannelHandlerContext ctx) {
        ctx.fireChannelUnregistered();
    }

    public void channelActive(ChannelHandlerContext ctx) {
        ctx.fireChannelActive();
    }

    public void channelInactive(ChannelHandlerContext ctx) {
        ctx.fireChannelInactive();
    }

    public void userEventTriggered(ChannelHandlerContext ctx, Object evt) {
        ctx.fireUserEventTriggered(evt);
    }

    public void channelWritabilityChanged(ChannelHandlerContext ctx) {
        ctx.fireChannelWritabilityChanged();
    }

    public void channelReadComplete(ChannelHandlerContext ctx) {
        ctx.fireChannelReadComplete();
    }
}

