/*
 * Decompiled with CFR 0.152.
 */
package infra.web.server.support;

import infra.lang.Nullable;
import infra.logging.Logger;
import infra.logging.LoggerFactory;
import infra.web.async.AsyncWebRequest;
import infra.web.server.support.NettyRequestContext;
import io.netty.channel.ChannelHandlerContext;
import io.netty.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import java.util.function.Consumer;

public class NettyAsyncWebRequest
extends AsyncWebRequest {
    private static final Logger log = LoggerFactory.getLogger(NettyAsyncWebRequest.class);
    private final NettyRequestContext request;
    private final ChannelHandlerContext channelContext;
    private volatile boolean asyncStarted;
    @Nullable
    private ScheduledFuture<?> timeoutFuture;

    NettyAsyncWebRequest(NettyRequestContext request) {
        this.request = request;
        this.channelContext = request.channelContext;
    }

    @Override
    public void startAsync() {
        if (this.timeout != null && this.timeout > 0L) {
            this.timeoutFuture = this.channelContext.executor().schedule(this::checkTimeout, this.timeout.longValue(), TimeUnit.MILLISECONDS);
        }
        this.asyncStarted = true;
    }

    private void checkTimeout() {
        if (!this.isAsyncComplete()) {
            log.debug("Async timeout, dispatch timeout events");
            this.dispatchEvent(this.timeoutHandlers);
        }
    }

    @Override
    public boolean isAsyncStarted() {
        return this.asyncStarted;
    }

    @Override
    public void dispatch(@Nullable Object concurrentResult) {
        this.asyncStarted = false;
        if (this.asyncCompleted.compareAndSet(false, true)) {
            if (this.timeoutFuture != null) {
                this.timeoutFuture.cancel(true);
            }
            this.channelContext.executor().execute(() -> {
                try {
                    this.request.dispatchConcurrentResult(concurrentResult);
                }
                catch (Throwable e) {
                    for (Consumer exceptionHandler : this.exceptionHandlers) {
                        exceptionHandler.accept(e);
                    }
                    this.channelContext.fireExceptionCaught(e);
                }
                finally {
                    this.dispatchEvent(this.completionHandlers);
                }
            });
        }
    }
}

