/*
 * Decompiled with CFR 0.152.
 */
package infra.web.server.reactive.support;

import infra.core.ssl.SslBundle;
import infra.core.ssl.SslOptions;
import infra.lang.Nullable;
import infra.logging.Logger;
import infra.logging.LoggerFactory;
import infra.web.server.Ssl;
import infra.web.server.reactive.support.ReactorNettyServerCustomizer;
import io.netty.handler.ssl.ClientAuth;
import java.time.Duration;
import java.util.HashMap;
import java.util.Map;
import javax.net.ssl.KeyManagerFactory;
import reactor.netty.http.Http11SslContextSpec;
import reactor.netty.http.Http2SslContextSpec;
import reactor.netty.http.server.HttpServer;
import reactor.netty.tcp.AbstractProtocolSslContextSpec;
import reactor.netty.tcp.SslProvider;

final class SslServerCustomizer
implements ReactorNettyServerCustomizer {
    private static final Logger logger = LoggerFactory.getLogger(SslServerCustomizer.class);
    private final boolean http2Enabled;
    private final ClientAuth clientAuth;
    private final Duration handshakeTimeout;
    private volatile SslProvider sslProvider;
    private final HashMap<String, SslProvider> serverNameSslProviders;

    public SslServerCustomizer(boolean http2Enabled, Ssl ssl, SslBundle sslBundle, Map<String, SslBundle> serverNameSslBundles) {
        this.http2Enabled = http2Enabled;
        this.handshakeTimeout = ssl.handshakeTimeout;
        this.clientAuth = Ssl.ClientAuth.map(ssl.clientAuth, ClientAuth.NONE, ClientAuth.OPTIONAL, ClientAuth.REQUIRE);
        this.sslProvider = this.createSslProvider(sslBundle);
        this.serverNameSslProviders = this.createServerNameSslProviders(serverNameSslBundles);
    }

    @Override
    public HttpServer apply(HttpServer server) {
        return server.secure(this::applySecurity);
    }

    private void applySecurity(SslProvider.SslContextSpec spec) {
        SslProvider.Builder builder = spec.sslContext(this.sslProvider.getSslContext()).handshakeTimeout(this.handshakeTimeout);
        if (!this.serverNameSslProviders.isEmpty()) {
            builder.setSniAsyncMappings((serverName, promise) -> promise.setSuccess((Object)this.serverNameSslProviders.getOrDefault(serverName, this.sslProvider)));
        }
    }

    void updateSslBundle(@Nullable String serverName, SslBundle sslBundle) {
        logger.debug("SSL Bundle has been updated, reloading SSL configuration");
        if (serverName == null) {
            this.sslProvider = this.createSslProvider(sslBundle);
        } else {
            this.serverNameSslProviders.put(serverName, this.createSslProvider(sslBundle));
        }
    }

    private HashMap<String, SslProvider> createServerNameSslProviders(Map<String, SslBundle> serverNameSslBundles) {
        HashMap<String, SslProvider> serverNameSslProviders = new HashMap<String, SslProvider>();
        for (Map.Entry<String, SslBundle> entry : serverNameSslBundles.entrySet()) {
            serverNameSslProviders.put(entry.getKey(), this.createSslProvider(entry.getValue()));
        }
        return serverNameSslProviders;
    }

    private SslProvider createSslProvider(SslBundle sslBundle) {
        return SslProvider.builder().sslContext(this.createSslContextSpec(sslBundle)).build();
    }

    private AbstractProtocolSslContextSpec<?> createSslContextSpec(SslBundle sslBundle) {
        Http2SslContextSpec sslContextSpec = this.http2Enabled ? Http2SslContextSpec.forServer((KeyManagerFactory)sslBundle.getManagers().getKeyManagerFactory()) : Http11SslContextSpec.forServer((KeyManagerFactory)sslBundle.getManagers().getKeyManagerFactory());
        return sslContextSpec.configure(builder -> {
            SslOptions options = sslBundle.getOptions();
            builder.trustManager(sslBundle.getManagers().getTrustManagerFactory());
            builder.protocols(options.getEnabledProtocols());
            builder.ciphers((Iterable)SslOptions.asSet((String[])options.getCiphers()));
            builder.clientAuth(this.clientAuth);
        });
    }
}

