/*
 * Decompiled with CFR 0.152.
 */
package infra.web.server.reactive.support;

import infra.http.client.ReactorResourceFactory;
import infra.http.server.reactive.ReactorHttpHandlerAdapter;
import infra.lang.Assert;
import infra.lang.Nullable;
import infra.logging.LoggerFactory;
import infra.web.server.GracefulShutdownCallback;
import infra.web.server.GracefulShutdownResult;
import infra.web.server.PortInUseException;
import infra.web.server.Shutdown;
import infra.web.server.WebServer;
import infra.web.server.WebServerException;
import infra.web.server.reactive.support.GracefulShutdown;
import infra.web.server.reactive.support.NettyRouteProvider;
import io.netty.channel.group.ChannelGroup;
import io.netty.channel.group.DefaultChannelGroup;
import io.netty.channel.unix.Errors;
import io.netty.util.concurrent.DefaultEventExecutor;
import io.netty.util.concurrent.EventExecutor;
import java.time.Duration;
import java.util.Collections;
import java.util.List;
import java.util.function.BiFunction;
import java.util.function.Predicate;
import java.util.function.Supplier;
import reactor.netty.ChannelBindException;
import reactor.netty.DisposableServer;
import reactor.netty.http.server.HttpServer;
import reactor.netty.http.server.HttpServerConfig;
import reactor.netty.http.server.HttpServerRequest;
import reactor.netty.http.server.HttpServerRoutes;
import reactor.netty.resources.LoopResources;

public class ReactorNettyWebServer
implements WebServer {
    private static final int ERROR_NO_EACCES = -13;
    private static final Predicate<HttpServerRequest> ALWAYS = request -> true;
    private final HttpServer httpServer;
    private final ReactorHttpHandlerAdapter handler;
    @Nullable
    private final Duration lifecycleTimeout;
    @Nullable
    private final GracefulShutdown gracefulShutdown;
    @Nullable
    private final ReactorResourceFactory resourceFactory;
    private List<NettyRouteProvider> routeProviders = Collections.emptyList();
    @Nullable
    private volatile DisposableServer disposableServer;

    public ReactorNettyWebServer(HttpServer httpServer, ReactorHttpHandlerAdapter handlerAdapter, @Nullable Duration lifecycleTimeout, Shutdown shutdown, @Nullable ReactorResourceFactory resourceFactory) {
        Assert.notNull((Object)httpServer, (String)"HttpServer is required");
        Assert.notNull((Object)handlerAdapter, (String)"HandlerAdapter is required");
        this.handler = handlerAdapter;
        this.resourceFactory = resourceFactory;
        this.lifecycleTimeout = lifecycleTimeout;
        this.httpServer = httpServer.channelGroup((ChannelGroup)new DefaultChannelGroup((EventExecutor)new DefaultEventExecutor()));
        this.gracefulShutdown = shutdown == Shutdown.GRACEFUL ? new GracefulShutdown(() -> this.disposableServer) : null;
    }

    public void setRouteProviders(List<NettyRouteProvider> routeProviders) {
        this.routeProviders = routeProviders;
    }

    @Override
    public void start() throws WebServerException {
        DisposableServer disposableServer = this.disposableServer;
        if (disposableServer == null) {
            try {
                this.disposableServer = disposableServer = this.startHttpServer();
            }
            catch (Exception ex) {
                PortInUseException.ifCausedBy(ex, ChannelBindException.class, bindException -> {
                    if (bindException.localPort() > 0 && !this.isPermissionDenied(bindException.getCause())) {
                        throw new PortInUseException(bindException.localPort(), (Throwable)ex);
                    }
                });
                throw new WebServerException("Unable to start Netty", ex);
            }
            LoggerFactory.getLogger(ReactorNettyWebServer.class).info(this.getStartedOnMessage(disposableServer));
            this.startDaemonAwaitThread(disposableServer);
        }
    }

    private String getStartedOnMessage(DisposableServer server) {
        StringBuilder message = new StringBuilder();
        this.tryAppend(message, "port %s", () -> server.port() + (((HttpServerConfig)this.httpServer.configuration()).sslProvider() != null ? " (https)" : " (http)"));
        this.tryAppend(message, "path %s", () -> ((DisposableServer)server).path());
        return !message.isEmpty() ? "Netty started on " + message : "Netty started";
    }

    protected String getStartedLogMessage() {
        return this.getStartedOnMessage(this.disposableServer);
    }

    private void tryAppend(StringBuilder message, String format, Supplier<Object> supplier) {
        try {
            Object value = supplier.get();
            message.append(!message.isEmpty() ? " " : "");
            message.append(String.format(format, value));
        }
        catch (UnsupportedOperationException unsupportedOperationException) {
            // empty catch block
        }
    }

    DisposableServer startHttpServer() {
        HttpServer server = this.httpServer;
        server = this.routeProviders.isEmpty() ? server.handle((BiFunction)this.handler) : server.route(this::applyRouteProviders);
        if (this.resourceFactory != null) {
            LoopResources resources = this.resourceFactory.getLoopResources();
            server = (HttpServer)server.runOn(resources);
        }
        if (this.lifecycleTimeout != null) {
            return server.bindNow(this.lifecycleTimeout);
        }
        return server.bindNow();
    }

    private boolean isPermissionDenied(Throwable bindExceptionCause) {
        try {
            if (bindExceptionCause instanceof Errors.NativeIoException) {
                Errors.NativeIoException e = (Errors.NativeIoException)bindExceptionCause;
                return e.expectedErr() == -13;
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        return false;
    }

    @Override
    public void shutDownGracefully(GracefulShutdownCallback callback) {
        if (this.gracefulShutdown == null) {
            callback.shutdownComplete(GracefulShutdownResult.IMMEDIATE);
            return;
        }
        this.gracefulShutdown.shutDownGracefully(callback);
    }

    private void applyRouteProviders(HttpServerRoutes routes) {
        for (NettyRouteProvider provider : this.routeProviders) {
            routes = (HttpServerRoutes)provider.apply(routes);
        }
        routes.route(ALWAYS, (BiFunction)this.handler);
    }

    private void startDaemonAwaitThread(final DisposableServer disposableServer) {
        Thread awaitThread = new Thread("server"){

            @Override
            public void run() {
                disposableServer.onDispose().block();
            }
        };
        awaitThread.setContextClassLoader(this.getClass().getClassLoader());
        awaitThread.setDaemon(false);
        awaitThread.start();
    }

    @Override
    public void stop() throws WebServerException {
        DisposableServer disposableServer = this.disposableServer;
        if (disposableServer != null) {
            if (this.gracefulShutdown != null) {
                this.gracefulShutdown.abort();
            }
            try {
                if (this.lifecycleTimeout != null) {
                    disposableServer.disposeNow(this.lifecycleTimeout);
                } else {
                    disposableServer.disposeNow();
                }
            }
            catch (IllegalStateException illegalStateException) {
                // empty catch block
            }
            this.disposableServer = null;
        }
    }

    @Override
    public int getPort() {
        DisposableServer disposableServer = this.disposableServer;
        if (disposableServer != null) {
            try {
                return disposableServer.port();
            }
            catch (UnsupportedOperationException ex) {
                return -1;
            }
        }
        return -1;
    }
}

