/*
 * Decompiled with CFR 0.152.
 */
package infra.web.server.reactive.support;

import infra.http.client.ReactorResourceFactory;
import infra.http.server.reactive.HttpHandler;
import infra.http.server.reactive.ReactorHttpHandlerAdapter;
import infra.lang.Assert;
import infra.lang.Nullable;
import infra.util.CollectionUtils;
import infra.web.server.Compression;
import infra.web.server.Shutdown;
import infra.web.server.Ssl;
import infra.web.server.WebServer;
import infra.web.server.reactive.AbstractReactiveWebServerFactory;
import infra.web.server.reactive.support.CompressionCustomizer;
import infra.web.server.reactive.support.NettyRouteProvider;
import infra.web.server.reactive.support.ReactorNettyServerCustomizer;
import infra.web.server.reactive.support.ReactorNettyWebServer;
import infra.web.server.reactive.support.SslServerCustomizer;
import java.net.InetSocketAddress;
import java.time.Duration;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import reactor.netty.http.HttpProtocol;
import reactor.netty.http.server.HttpServer;

public class ReactorNettyReactiveWebServerFactory
extends AbstractReactiveWebServerFactory {
    private Set<ReactorNettyServerCustomizer> serverCustomizers = new LinkedHashSet<ReactorNettyServerCustomizer>();
    private final List<NettyRouteProvider> routeProviders = new ArrayList<NettyRouteProvider>();
    @Nullable
    private Duration lifecycleTimeout;
    private boolean useForwardHeaders;
    @Nullable
    private ReactorResourceFactory resourceFactory;

    public ReactorNettyReactiveWebServerFactory() {
    }

    public ReactorNettyReactiveWebServerFactory(int port) {
        super(port);
    }

    @Override
    public WebServer getWebServer(HttpHandler httpHandler) {
        HttpServer httpServer = this.createHttpServer();
        ReactorHttpHandlerAdapter handlerAdapter = new ReactorHttpHandlerAdapter(httpHandler);
        ReactorNettyWebServer webServer = this.createNettyWebServer(httpServer, handlerAdapter, this.lifecycleTimeout, this.getShutdown());
        webServer.setRouteProviders(this.routeProviders);
        return webServer;
    }

    ReactorNettyWebServer createNettyWebServer(HttpServer httpServer, ReactorHttpHandlerAdapter handlerAdapter, @Nullable Duration lifecycleTimeout, Shutdown shutdown) {
        return new ReactorNettyWebServer(httpServer, handlerAdapter, lifecycleTimeout, shutdown, this.resourceFactory);
    }

    public Collection<ReactorNettyServerCustomizer> getServerCustomizers() {
        return this.serverCustomizers;
    }

    public void setServerCustomizers(Collection<? extends ReactorNettyServerCustomizer> serverCustomizers) {
        Assert.notNull(serverCustomizers, (String)"ServerCustomizers is required");
        this.serverCustomizers = new LinkedHashSet<ReactorNettyServerCustomizer>(serverCustomizers);
    }

    public void addServerCustomizers(ReactorNettyServerCustomizer ... serverCustomizers) {
        CollectionUtils.addAll(this.serverCustomizers, (Object[])serverCustomizers);
    }

    public void addRouteProviders(NettyRouteProvider ... routeProviders) {
        CollectionUtils.addAll(this.routeProviders, (Object[])routeProviders);
    }

    public void setLifecycleTimeout(Duration lifecycleTimeout) {
        this.lifecycleTimeout = lifecycleTimeout;
    }

    public void setUseForwardHeaders(boolean useForwardHeaders) {
        this.useForwardHeaders = useForwardHeaders;
    }

    public void setResourceFactory(ReactorResourceFactory resourceFactory) {
        this.resourceFactory = resourceFactory;
    }

    private HttpServer createHttpServer() {
        HttpServer server = HttpServer.create().bindAddress(this::getListenAddress);
        if (Ssl.isEnabled(this.getSsl())) {
            server = this.customizeSslConfiguration(this.getSsl(), server);
        }
        if (Compression.isEnabled(this.getCompression())) {
            server = new CompressionCustomizer(this.getCompression()).apply(server);
        }
        server = server.protocol(this.listProtocols()).forwarded(this.useForwardHeaders);
        return this.applyCustomizers(server);
    }

    private HttpServer customizeSslConfiguration(Ssl ssl, HttpServer httpServer) {
        SslServerCustomizer customizer = new SslServerCustomizer(this.isHttp2Enabled(), ssl, this.getSslBundle(), this.getServerNameSslBundles());
        this.addBundleUpdateHandler(ssl, customizer::updateSslBundle);
        return customizer.apply(httpServer);
    }

    private HttpProtocol[] listProtocols() {
        ArrayList<HttpProtocol> protocols = new ArrayList<HttpProtocol>();
        protocols.add(HttpProtocol.HTTP11);
        if (this.isHttp2Enabled()) {
            if (Ssl.isEnabled(this.getSsl())) {
                protocols.add(HttpProtocol.H2);
            } else {
                protocols.add(HttpProtocol.H2C);
            }
        }
        return protocols.toArray(new HttpProtocol[0]);
    }

    private InetSocketAddress getListenAddress() {
        if (this.getAddress() != null) {
            return new InetSocketAddress(this.getAddress().getHostAddress(), this.getPort());
        }
        return new InetSocketAddress(this.getPort());
    }

    private HttpServer applyCustomizers(HttpServer server) {
        for (ReactorNettyServerCustomizer customizer : this.serverCustomizers) {
            server = (HttpServer)customizer.apply(server);
        }
        return server;
    }
}

