/*
 * Decompiled with CFR 0.152.
 */
package infra.web.server.reactive.support;

import infra.lang.Nullable;
import infra.logging.Logger;
import infra.logging.LoggerFactory;
import infra.web.server.GracefulShutdownCallback;
import infra.web.server.GracefulShutdownResult;
import java.time.Duration;
import java.util.function.Supplier;
import reactor.netty.DisposableServer;

final class GracefulShutdown {
    private static final Logger logger = LoggerFactory.getLogger(GracefulShutdown.class);
    private final Supplier<DisposableServer> disposableServer;
    @Nullable
    private volatile Thread shutdownThread;
    private volatile boolean shuttingDown;

    GracefulShutdown(Supplier<DisposableServer> disposableServer) {
        this.disposableServer = disposableServer;
    }

    void shutDownGracefully(GracefulShutdownCallback callback) {
        Thread thread;
        DisposableServer server = this.disposableServer.get();
        if (server == null) {
            return;
        }
        logger.info("Commencing graceful shutdown. Waiting for active requests to complete");
        this.shutdownThread = thread = new Thread(() -> this.doShutdown(callback, server), "netty-shutdown");
        thread.start();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void doShutdown(GracefulShutdownCallback callback, DisposableServer server) {
        this.shuttingDown = true;
        try {
            server.disposeNow(Duration.ofNanos(Long.MAX_VALUE));
            logger.info("Graceful shutdown complete");
            callback.shutdownComplete(GracefulShutdownResult.IDLE);
        }
        catch (Exception ex) {
            logger.info("Graceful shutdown aborted with one or more requests still active");
            callback.shutdownComplete(GracefulShutdownResult.REQUESTS_ACTIVE);
        }
        finally {
            this.shutdownThread = null;
            this.shuttingDown = false;
        }
    }

    void abort() {
        Thread shutdownThread = this.shutdownThread;
        if (shutdownThread != null) {
            while (!this.shuttingDown) {
                GracefulShutdown.sleep(50L);
            }
            shutdownThread.interrupt();
        }
    }

    private static void sleep(long millis) {
        try {
            Thread.sleep(millis);
        }
        catch (InterruptedException ex) {
            Thread.currentThread().interrupt();
        }
    }
}

