/*
 * Decompiled with CFR 0.152.
 */
package infra.web.server.reactive.support;

import infra.lang.Nullable;
import infra.util.InvalidMimeTypeException;
import infra.util.MimeType;
import infra.util.MimeTypeUtils;
import infra.util.ObjectUtils;
import infra.util.StringUtils;
import infra.web.server.Compression;
import infra.web.server.reactive.support.ReactorNettyServerCustomizer;
import io.netty.handler.codec.http.HttpHeaderNames;
import io.netty.handler.codec.http.HttpHeaders;
import java.util.Arrays;
import java.util.List;
import java.util.function.BiPredicate;
import reactor.netty.http.server.HttpServer;
import reactor.netty.http.server.HttpServerRequest;
import reactor.netty.http.server.HttpServerResponse;

final class CompressionCustomizer
implements ReactorNettyServerCustomizer {
    private static final CompressionPredicate ALWAYS_COMPRESS = (request, response) -> true;
    private final Compression compression;

    CompressionCustomizer(Compression compression) {
        this.compression = compression;
    }

    @Override
    public HttpServer apply(HttpServer server) {
        if (!this.compression.getMinResponseSize().isNegative()) {
            server = server.compress(this.compression.getMinResponseSize().toBytesInt());
        }
        CompressionPredicate mimeTypes = this.getMimeTypesPredicate(this.compression.getMimeTypes());
        CompressionPredicate excludedUserAgents = this.getExcludedUserAgentsPredicate(this.compression.getExcludedUserAgents());
        return server.compress(mimeTypes.and(excludedUserAgents));
    }

    private CompressionPredicate getMimeTypesPredicate(String[] mimeTypeValues) {
        if (ObjectUtils.isEmpty((Object[])mimeTypeValues)) {
            return ALWAYS_COMPRESS;
        }
        List<MimeType> mimeTypes = Arrays.stream(mimeTypeValues).map(MimeTypeUtils::parseMimeType).toList();
        return (request, response) -> {
            String contentType = response.responseHeaders().get((CharSequence)HttpHeaderNames.CONTENT_TYPE);
            if (StringUtils.isEmpty((CharSequence)contentType)) {
                return false;
            }
            try {
                MimeType contentMimeType = MimeTypeUtils.parseMimeType((String)contentType);
                return mimeTypes.stream().anyMatch(candidate -> candidate.isCompatibleWith(contentMimeType));
            }
            catch (InvalidMimeTypeException ex) {
                return false;
            }
        };
    }

    private CompressionPredicate getExcludedUserAgentsPredicate(@Nullable String[] excludedUserAgents) {
        if (ObjectUtils.isEmpty((Object[])excludedUserAgents)) {
            return ALWAYS_COMPRESS;
        }
        return (request, response) -> {
            HttpHeaders headers = request.requestHeaders();
            return Arrays.stream(excludedUserAgents).noneMatch(candidate -> headers.contains((CharSequence)HttpHeaderNames.USER_AGENT, (CharSequence)candidate, true));
        };
    }

    private static interface CompressionPredicate
    extends BiPredicate<HttpServerRequest, HttpServerResponse> {
    }
}

