/*
 * Decompiled with CFR 0.152.
 */
package infra.web.server.reactive.context;

import infra.http.server.reactive.HttpHandler;
import infra.http.server.reactive.ServerHttpRequest;
import infra.http.server.reactive.ServerHttpResponse;
import infra.lang.Assert;
import infra.web.server.WebServer;
import infra.web.server.reactive.ReactiveWebServerFactory;
import infra.web.server.reactive.context.ReactiveWebServerApplicationContext;
import infra.web.server.reactive.context.ReactiveWebServerInitializedEvent;
import java.util.function.Supplier;
import reactor.core.publisher.Mono;

final class WebServerManager {
    public final ReactiveWebServerApplicationContext applicationContext;
    public final DelayedInitializationHttpHandler handler;
    public final WebServer webServer;

    WebServerManager(ReactiveWebServerApplicationContext applicationContext, ReactiveWebServerFactory factory, Supplier<HttpHandler> handlerSupplier, boolean lazyInit) {
        Assert.notNull((Object)factory, (String)"Factory is required");
        this.applicationContext = applicationContext;
        this.handler = new DelayedInitializationHttpHandler(handlerSupplier, lazyInit);
        this.webServer = factory.getWebServer(this.handler);
    }

    void start() {
        this.handler.initializeHandler();
        this.webServer.start();
        this.applicationContext.publishEvent(new ReactiveWebServerInitializedEvent(this.webServer, this.applicationContext));
    }

    void stop() {
        this.webServer.stop();
    }

    static final class DelayedInitializationHttpHandler
    implements HttpHandler {
        private final Supplier<HttpHandler> handlerSupplier;
        private final boolean lazyInit;
        volatile HttpHandler delegate = this::handleUninitialized;

        private DelayedInitializationHttpHandler(Supplier<HttpHandler> handlerSupplier, boolean lazyInit) {
            this.handlerSupplier = handlerSupplier;
            this.lazyInit = lazyInit;
        }

        private Mono<Void> handleUninitialized(ServerHttpRequest request, ServerHttpResponse response) {
            throw new IllegalStateException("The HttpHandler has not yet been initialized");
        }

        @Override
        public Mono<Void> handle(ServerHttpRequest request, ServerHttpResponse response) {
            return this.delegate.handle(request, response);
        }

        void initializeHandler() {
            this.delegate = this.lazyInit ? new LazyHttpHandler(this.handlerSupplier) : this.handlerSupplier.get();
        }
    }

    private static final class LazyHttpHandler
    implements HttpHandler {
        private final Mono<HttpHandler> delegate;

        private LazyHttpHandler(Supplier<HttpHandler> handlerSupplier) {
            this.delegate = Mono.fromSupplier(handlerSupplier);
        }

        @Override
        public Mono<Void> handle(ServerHttpRequest request, ServerHttpResponse response) {
            return this.delegate.flatMap(handler -> handler.handle(request, response));
        }
    }
}

