/*
 * Decompiled with CFR 0.152.
 */
package infra.web.server.reactive.context;

import infra.beans.BeansException;
import infra.beans.factory.config.ConfigurableBeanFactory;
import infra.beans.factory.support.StandardBeanFactory;
import infra.context.ApplicationContextException;
import infra.http.server.reactive.HttpHandler;
import infra.lang.Nullable;
import infra.util.CollectionUtils;
import infra.util.StringUtils;
import infra.web.server.WebServer;
import infra.web.server.context.ConfigurableWebServerApplicationContext;
import infra.web.server.context.MissingWebServerFactoryBeanException;
import infra.web.server.context.WebServerGracefulShutdownLifecycle;
import infra.web.server.reactive.ReactiveWebServerFactory;
import infra.web.server.reactive.context.GenericReactiveWebApplicationContext;
import infra.web.server.reactive.context.WebServerManager;
import infra.web.server.reactive.context.WebServerStartStopLifecycle;
import java.util.Collection;
import java.util.Set;

public class ReactiveWebServerApplicationContext
extends GenericReactiveWebApplicationContext
implements ConfigurableWebServerApplicationContext {
    @Nullable
    private volatile WebServerManager serverManager;
    private String serverNamespace;

    public ReactiveWebServerApplicationContext() {
    }

    public ReactiveWebServerApplicationContext(StandardBeanFactory beanFactory) {
        super(beanFactory);
    }

    public final void refresh() throws BeansException, IllegalStateException {
        try {
            super.refresh();
        }
        catch (RuntimeException ex) {
            WebServerManager serverManager = this.serverManager;
            if (serverManager != null) {
                serverManager.webServer.stop();
            }
            throw ex;
        }
    }

    protected void onRefresh() {
        super.onRefresh();
        try {
            this.createWebServer();
        }
        catch (Throwable ex) {
            throw new ApplicationContextException("Unable to start reactive web server", ex);
        }
    }

    private void createWebServer() {
        WebServerManager serverManager = this.serverManager;
        if (serverManager == null) {
            String webServerFactoryBeanName = this.getWebServerFactoryBeanName();
            StandardBeanFactory beanFactory = this.getBeanFactory();
            ReactiveWebServerFactory webServerFactory = this.getWebServerFactory((ConfigurableBeanFactory)beanFactory, webServerFactoryBeanName);
            boolean lazyInit = beanFactory.getBeanDefinition(webServerFactoryBeanName).isLazyInit();
            serverManager = new WebServerManager(this, webServerFactory, this::getHttpHandler, lazyInit);
            beanFactory.registerSingleton("webServerGracefulShutdown", (Object)new WebServerGracefulShutdownLifecycle(serverManager.webServer));
            beanFactory.registerSingleton("webServerStartStop", (Object)new WebServerStartStopLifecycle(serverManager));
            this.serverManager = serverManager;
        }
        this.initPropertySources();
    }

    protected String getWebServerFactoryBeanName() {
        Set beanNames = this.getBeanFactory().getBeanNamesForType(ReactiveWebServerFactory.class);
        if (beanNames.isEmpty()) {
            throw new MissingWebServerFactoryBeanException(this.getClass(), ReactiveWebServerFactory.class);
        }
        if (beanNames.size() > 1) {
            throw new ApplicationContextException("Unable to start ReactiveWebApplicationContext due to multiple ReactiveWebServerFactory beans : " + StringUtils.collectionToCommaDelimitedString((Collection)beanNames));
        }
        return (String)CollectionUtils.firstElement((Iterable)beanNames);
    }

    protected ReactiveWebServerFactory getWebServerFactory(ConfigurableBeanFactory beanFactory, String factoryBeanName) {
        return (ReactiveWebServerFactory)beanFactory.getBean(factoryBeanName, ReactiveWebServerFactory.class);
    }

    protected HttpHandler getHttpHandler() {
        Set beanNames = this.getBeanFactory().getBeanNamesForType(HttpHandler.class);
        if (beanNames.isEmpty()) {
            throw new ApplicationContextException("Unable to start ReactiveWebApplicationContext due to missing HttpHandler bean.");
        }
        if (beanNames.size() > 1) {
            throw new ApplicationContextException("Unable to start ReactiveWebApplicationContext due to multiple HttpHandler beans : " + StringUtils.collectionToCommaDelimitedString((Collection)beanNames));
        }
        return (HttpHandler)this.getBeanFactory().getBean((String)CollectionUtils.firstElement((Iterable)beanNames), HttpHandler.class);
    }

    @Override
    @Nullable
    public WebServer getWebServer() {
        WebServerManager serverManager = this.serverManager;
        return serverManager != null ? serverManager.webServer : null;
    }

    @Override
    @Nullable
    public String getServerNamespace() {
        return this.serverNamespace;
    }

    @Override
    public void setServerNamespace(String serverNamespace) {
        this.serverNamespace = serverNamespace;
    }
}

