/*
 * Decompiled with CFR 0.152.
 */
package infra.web.server.reactive.context;

import infra.core.io.AbstractResource;
import infra.core.io.Resource;
import infra.util.StringUtils;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;

class FilteredReactiveWebContextResource
extends AbstractResource {
    private final String path;

    FilteredReactiveWebContextResource(String path) {
        this.path = path;
    }

    public boolean exists() {
        return false;
    }

    public Resource createRelative(String relativePath) throws IOException {
        String pathToUse = StringUtils.applyRelativePath((String)this.path, (String)relativePath);
        return new FilteredReactiveWebContextResource(pathToUse);
    }

    public String toString() {
        return "ReactiveWebContext resource [" + this.path + "]";
    }

    public InputStream getInputStream() throws IOException {
        throw new FileNotFoundException(this + " cannot be opened because it does not exist");
    }
}

