/*
 * Decompiled with CFR 0.152.
 */
package infra.web.server.reactive.context;

import infra.beans.factory.config.ConfigurableBeanFactory;
import infra.beans.factory.support.BeanDefinitionRegistry;
import infra.beans.factory.support.BeanNameGenerator;
import infra.beans.factory.support.StandardBeanFactory;
import infra.context.AnnotationConfigRegistry;
import infra.context.annotation.AnnotatedBeanDefinitionReader;
import infra.context.annotation.ClassPathBeanDefinitionScanner;
import infra.context.annotation.ScopeMetadataResolver;
import infra.core.env.ConfigurableEnvironment;
import infra.core.env.Environment;
import infra.lang.Assert;
import infra.util.ClassUtils;
import infra.util.ObjectUtils;
import infra.web.server.reactive.context.ReactiveWebServerApplicationContext;
import java.util.Arrays;
import java.util.LinkedHashSet;
import java.util.Set;

public class AnnotationConfigReactiveWebServerApplicationContext
extends ReactiveWebServerApplicationContext
implements AnnotationConfigRegistry {
    private final AnnotatedBeanDefinitionReader reader;
    private final ClassPathBeanDefinitionScanner scanner;
    private final Set<Class<?>> annotatedClasses = new LinkedHashSet();
    private String[] basePackages;

    public AnnotationConfigReactiveWebServerApplicationContext() {
        this.reader = new AnnotatedBeanDefinitionReader((BeanDefinitionRegistry)this);
        this.scanner = new ClassPathBeanDefinitionScanner((BeanDefinitionRegistry)this);
    }

    public AnnotationConfigReactiveWebServerApplicationContext(StandardBeanFactory beanFactory) {
        super(beanFactory);
        this.reader = new AnnotatedBeanDefinitionReader((BeanDefinitionRegistry)this);
        this.scanner = new ClassPathBeanDefinitionScanner((BeanDefinitionRegistry)this);
    }

    public AnnotationConfigReactiveWebServerApplicationContext(Class<?> ... annotatedClasses) {
        this();
        this.register(annotatedClasses);
        this.refresh();
    }

    public AnnotationConfigReactiveWebServerApplicationContext(String ... basePackages) {
        this();
        this.scan(basePackages);
        this.refresh();
    }

    public void setEnvironment(ConfigurableEnvironment environment) {
        super.setEnvironment(environment);
        this.reader.setEnvironment((Environment)environment);
        this.scanner.setEnvironment((Environment)environment);
    }

    public void setBeanNameGenerator(BeanNameGenerator beanNameGenerator) {
        this.reader.setBeanNameGenerator(beanNameGenerator);
        this.scanner.setBeanNameGenerator(beanNameGenerator);
        this.getBeanFactory().registerSingleton("infra.context.annotation.internalConfigurationBeanNameGenerator", (Object)beanNameGenerator);
    }

    public void setScopeMetadataResolver(ScopeMetadataResolver scopeMetadataResolver) {
        this.reader.setScopeMetadataResolver(scopeMetadataResolver);
        this.scanner.setScopeMetadataResolver(scopeMetadataResolver);
    }

    public final void register(Class<?> ... annotatedClasses) {
        Assert.notEmpty((Object[])annotatedClasses, (String)"At least one annotated class must be specified");
        this.annotatedClasses.addAll(Arrays.asList(annotatedClasses));
    }

    public final void scan(String ... basePackages) {
        Assert.notEmpty((Object[])basePackages, (String)"At least one base package must be specified");
        this.basePackages = basePackages;
    }

    protected void prepareRefresh() {
        this.scanner.clearCache();
        super.prepareRefresh();
    }

    @Override
    protected void postProcessBeanFactory(ConfigurableBeanFactory beanFactory) {
        super.postProcessBeanFactory(beanFactory);
        if (ObjectUtils.isNotEmpty((Object[])this.basePackages)) {
            this.scanner.scan(this.basePackages);
        }
        if (!this.annotatedClasses.isEmpty()) {
            this.reader.register(ClassUtils.toClassArray(this.annotatedClasses));
        }
    }
}

