/*
 * Decompiled with CFR 0.152.
 */
package infra.web.server.error;

import infra.context.ApplicationContext;
import infra.core.Ordered;
import infra.core.io.Resource;
import infra.http.HttpStatus;
import infra.http.HttpStatusCode;
import infra.lang.Assert;
import infra.lang.Nullable;
import infra.ui.template.TemplateAvailabilityProvider;
import infra.ui.template.TemplateAvailabilityProviders;
import infra.util.FileCopyUtils;
import infra.web.RequestContext;
import infra.web.server.error.ErrorViewResolver;
import infra.web.view.ModelAndView;
import infra.web.view.View;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Collections;
import java.util.EnumMap;
import java.util.Map;

public class DefaultErrorViewResolver
implements ErrorViewResolver,
Ordered {
    private static final Map<HttpStatus.Series, String> SERIES_VIEWS;
    private final ApplicationContext applicationContext;
    private final String[] staticLocations;
    private final TemplateAvailabilityProviders templateAvailabilityProviders;
    private int order = Integer.MAX_VALUE;

    public DefaultErrorViewResolver(ApplicationContext applicationContext, String[] staticLocations) {
        this(applicationContext, staticLocations, new TemplateAvailabilityProviders(applicationContext));
    }

    public DefaultErrorViewResolver(ApplicationContext applicationContext, String[] staticLocations, TemplateAvailabilityProviders providers) {
        Assert.notNull((Object)staticLocations, (String)"staticLocations is required");
        Assert.notNull((Object)applicationContext, (String)"ApplicationContext is required");
        this.applicationContext = applicationContext;
        this.staticLocations = staticLocations;
        this.templateAvailabilityProviders = providers;
    }

    @Override
    public ModelAndView resolveErrorView(RequestContext request, HttpStatusCode status, Map<String, Object> model) {
        HttpStatus.Series series;
        ModelAndView view = this.resolve(String.valueOf(status.value()), model);
        if (view == null && SERIES_VIEWS.containsKey((Object)(series = HttpStatus.Series.resolve(status.value())))) {
            view = this.resolve(SERIES_VIEWS.get((Object)series), model);
        }
        return view;
    }

    private ModelAndView resolve(String viewName, Map<String, Object> model) {
        String errorViewName = "error/" + viewName;
        TemplateAvailabilityProvider provider = this.templateAvailabilityProviders.getProvider(errorViewName, this.applicationContext);
        if (provider != null) {
            return new ModelAndView(errorViewName, model);
        }
        return this.resolveResource(errorViewName, model);
    }

    private ModelAndView resolveResource(String viewName, Map<String, Object> model) {
        for (String location : this.staticLocations) {
            try {
                Resource resource = this.applicationContext.getResource(location);
                resource = resource.createRelative(viewName + ".html");
                if (!resource.exists()) continue;
                return new ModelAndView(new HtmlResourceView(resource), model);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return null;
    }

    public int getOrder() {
        return this.order;
    }

    public void setOrder(int order) {
        this.order = order;
    }

    static {
        EnumMap<HttpStatus.Series, String> views = new EnumMap<HttpStatus.Series, String>(HttpStatus.Series.class);
        views.put(HttpStatus.Series.CLIENT_ERROR, "4xx");
        views.put(HttpStatus.Series.SERVER_ERROR, "5xx");
        SERIES_VIEWS = Collections.unmodifiableMap(views);
    }

    private static class HtmlResourceView
    implements View {
        private final Resource resource;

        HtmlResourceView(Resource resource) {
            this.resource = resource;
        }

        @Override
        public String getContentType() {
            return "text/html";
        }

        @Override
        public void render(@Nullable Map<String, ?> model, RequestContext request) throws Exception {
            request.setContentType(this.getContentType());
            FileCopyUtils.copy((InputStream)this.resource.getInputStream(), (OutputStream)request.getOutputStream());
        }
    }
}

