/*
 * Decompiled with CFR 0.152.
 */
package infra.web.server.error;

import infra.core.Ordered;
import infra.http.HttpStatus;
import infra.lang.Nullable;
import infra.util.StringUtils;
import infra.validation.BindingResult;
import infra.web.HttpStatusProvider;
import infra.web.RequestContext;
import infra.web.ResponseStatusException;
import infra.web.server.error.ErrorAttributeOptions;
import infra.web.server.error.ErrorAttributes;
import infra.web.util.WebUtils;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.time.Instant;
import java.util.HashMap;
import java.util.Map;

public class DefaultErrorAttributes
implements ErrorAttributes,
Ordered {
    public int getOrder() {
        return Integer.MIN_VALUE;
    }

    @Override
    public Map<String, Object> getErrorAttributes(RequestContext context, ErrorAttributeOptions options) {
        HashMap<String, Object> errorAttributes = new HashMap<String, Object>();
        errorAttributes.put("timestamp", Instant.now());
        this.addPath(context, errorAttributes);
        this.addStatus(errorAttributes, context);
        this.addErrorDetails(errorAttributes, context, options);
        if (!options.isIncluded(ErrorAttributeOptions.Include.PATH)) {
            errorAttributes.remove("path");
        }
        return errorAttributes;
    }

    private void addPath(RequestContext request, HashMap<String, Object> attributes) {
        attributes.put("path", request.getRequestURI());
    }

    private void addStatus(Map<String, Object> attributes, RequestContext request) {
        int status = request.getStatus();
        Throwable error = this.getError(request);
        if (error instanceof HttpStatusProvider) {
            HttpStatusProvider provider = (HttpStatusProvider)((Object)error);
            status = provider.getStatusCode().value();
        }
        if (status == 200) {
            attributes.put("status", 999);
            attributes.put("error", "None");
            return;
        }
        attributes.put("status", status);
        try {
            attributes.put("error", HttpStatus.valueOf(status).getReasonPhrase());
        }
        catch (Exception ex) {
            attributes.put("error", "Http Status " + status);
        }
    }

    private void addErrorDetails(Map<String, Object> attributes, RequestContext request, ErrorAttributeOptions options) {
        Throwable error = this.getError(request);
        if (error != null) {
            if (options.isIncluded(ErrorAttributeOptions.Include.EXCEPTION)) {
                attributes.put("exception", error.getClass().getName());
            }
            if (options.isIncluded(ErrorAttributeOptions.Include.STACK_TRACE)) {
                StringWriter stackTrace = new StringWriter();
                error.printStackTrace(new PrintWriter(stackTrace));
                stackTrace.flush();
                attributes.put("trace", stackTrace.toString());
            }
        }
        if (error instanceof BindingResult) {
            BindingResult result = (BindingResult)error;
            if (options.isIncluded(ErrorAttributeOptions.Include.BINDING_ERRORS)) {
                attributes.put("errors", result.getAllErrors());
            }
            if (options.isIncluded(ErrorAttributeOptions.Include.MESSAGE)) {
                attributes.put("message", "Validation failed for object='%s'. Error count: %d".formatted(result.getObjectName(), result.getErrorCount()));
            }
        } else if (error instanceof ResponseStatusException) {
            ResponseStatusException rse = (ResponseStatusException)((Object)error);
            if (options.isIncluded(ErrorAttributeOptions.Include.MESSAGE)) {
                attributes.put("message", rse.getReason());
            }
            Throwable throwable = error = rse.getCause() != null ? rse.getCause() : error;
            if (error instanceof BindingResult) {
                BindingResult bindingResult = (BindingResult)error;
                if (options.isIncluded(ErrorAttributeOptions.Include.BINDING_ERRORS)) {
                    attributes.put("errors", bindingResult.getAllErrors());
                }
            }
        } else if (options.isIncluded(ErrorAttributeOptions.Include.MESSAGE)) {
            attributes.put("message", this.getMessage(request, error));
        }
    }

    protected String getMessage(RequestContext request, Throwable error) {
        String message;
        Object attribute = request.getAttribute(WebUtils.ERROR_MESSAGE_ATTRIBUTE);
        if (attribute instanceof String && StringUtils.hasText((String)(message = (String)attribute))) {
            return message;
        }
        if (error != null && StringUtils.hasText((String)error.getMessage())) {
            return error.getMessage();
        }
        return "No message available";
    }

    @Override
    @Nullable
    public Throwable getError(RequestContext request) {
        Object attribute = request.getAttribute(WebUtils.ERROR_EXCEPTION_ATTRIBUTE);
        if (attribute instanceof Throwable) {
            Throwable exception = (Throwable)attribute;
            return exception;
        }
        return null;
    }
}

