/*
 * Decompiled with CFR 0.152.
 */
package infra.web.server.error;

import infra.http.HttpStatus;
import infra.http.InvalidMediaTypeException;
import infra.http.MediaType;
import infra.http.ResponseEntity;
import infra.lang.Nullable;
import infra.stereotype.Controller;
import infra.util.ExceptionUtils;
import infra.util.MimeTypeUtils;
import infra.util.StringUtils;
import infra.web.HttpMediaTypeNotAcceptableException;
import infra.web.HttpRequestHandler;
import infra.web.RequestContext;
import infra.web.annotation.ExceptionHandler;
import infra.web.annotation.RequestMapping;
import infra.web.handler.ReturnValueHandlerManager;
import infra.web.server.error.AbstractErrorController;
import infra.web.server.error.ErrorAttributes;
import infra.web.server.error.ErrorProperties;
import infra.web.server.error.ErrorViewResolver;
import infra.web.server.error.SendErrorHandler;
import infra.web.util.WebUtils;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

@Controller
public class BasicErrorController
extends AbstractErrorController
implements SendErrorHandler {
    private final ReturnValueHandlerManager returnValueHandler;

    public BasicErrorController(ErrorAttributes errorAttributes, ErrorProperties errorProperties, List<ErrorViewResolver> errorViewResolvers, ReturnValueHandlerManager returnValueHandler) {
        super(errorAttributes, errorProperties, errorViewResolvers);
        this.returnValueHandler = returnValueHandler;
    }

    @RequestMapping(value={"${server.error.path:${error.path:/error}}"})
    public Object error(RequestContext request) {
        return this.handleRequest(request, null);
    }

    @Override
    public void handleError(RequestContext request, @Nullable String message) {
        Object returnValue = this.handleRequest(request, message);
        if (returnValue != HttpRequestHandler.NONE_RETURN_VALUE) {
            try {
                this.returnValueHandler.handleReturnValue(request, null, returnValue);
            }
            catch (Throwable e) {
                throw ExceptionUtils.sneakyThrow((Throwable)e);
            }
        }
    }

    private Object handleRequest(RequestContext request, @Nullable String message) {
        boolean acceptsTextHtml;
        HttpStatus status;
        if (StringUtils.hasText((String)message)) {
            request.setAttribute(WebUtils.ERROR_MESSAGE_ATTRIBUTE, message);
        }
        if ((status = this.getStatus(request)).is2xxSuccessful()) {
            status = HttpStatus.INTERNAL_SERVER_ERROR;
        }
        Map<String, Object> model = this.getErrorAttributes(request, (acceptsTextHtml = BasicErrorController.ifAcceptsTextHtml(request)) ? MediaType.TEXT_HTML : MediaType.ALL);
        request.setStatus(status);
        if (acceptsTextHtml) {
            request.setContentType(MediaType.TEXT_HTML);
            return this.resolveErrorView(request, status, model);
        }
        return model;
    }

    static boolean ifAcceptsTextHtml(RequestContext context) {
        try {
            ArrayList<MediaType> acceptedMediaTypes = new ArrayList<MediaType>(context.getHeaders().getAccept());
            acceptedMediaTypes.removeIf(arg_0 -> ((MediaType)MediaType.ALL).equalsTypeAndSubtype(arg_0));
            MimeTypeUtils.sortBySpecificity(acceptedMediaTypes);
            return acceptedMediaTypes.stream().anyMatch(MediaType.TEXT_HTML::isCompatibleWith);
        }
        catch (InvalidMediaTypeException ex) {
            return false;
        }
    }

    @ExceptionHandler(value={HttpMediaTypeNotAcceptableException.class})
    public ResponseEntity<String> mediaTypeNotAcceptable(RequestContext request) {
        HttpStatus status = this.getStatus(request);
        return ResponseEntity.status(status).build();
    }
}

