/*
 * Decompiled with CFR 0.152.
 */
package infra.web.server.error;

import infra.core.annotation.AnnotationAwareOrderComparator;
import infra.http.HttpStatus;
import infra.http.HttpStatusCode;
import infra.http.MediaType;
import infra.lang.Assert;
import infra.lang.Nullable;
import infra.web.RequestContext;
import infra.web.server.error.ErrorAttributeOptions;
import infra.web.server.error.ErrorAttributes;
import infra.web.server.error.ErrorController;
import infra.web.server.error.ErrorProperties;
import infra.web.server.error.ErrorViewResolver;
import infra.web.server.error.IncludeAttribute;
import infra.web.view.ModelAndView;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

public abstract class AbstractErrorController
implements ErrorController {
    protected final ErrorAttributes errorAttributes;
    protected final ErrorProperties errorProperties;
    protected final List<ErrorViewResolver> errorViewResolvers;

    public AbstractErrorController(ErrorAttributes errorAttributes, ErrorProperties errorProperties, @Nullable List<ErrorViewResolver> errorViewResolvers) {
        Assert.notNull((Object)errorAttributes, (String)"ErrorAttributes is required");
        Assert.notNull((Object)errorProperties, (String)"ErrorProperties is required");
        this.errorAttributes = errorAttributes;
        this.errorProperties = errorProperties;
        this.errorViewResolvers = this.sortErrorViewResolvers(errorViewResolvers);
    }

    private List<ErrorViewResolver> sortErrorViewResolvers(@Nullable List<ErrorViewResolver> resolvers) {
        ArrayList<ErrorViewResolver> sorted = new ArrayList<ErrorViewResolver>();
        if (resolvers != null) {
            sorted.addAll(resolvers);
            AnnotationAwareOrderComparator.sort(sorted);
        }
        return sorted;
    }

    protected Map<String, Object> getErrorAttributes(RequestContext request, MediaType mediaType) {
        return this.errorAttributes.getErrorAttributes(request, this.getErrorAttributeOptions(request, mediaType));
    }

    protected boolean getTraceParameter(RequestContext request) {
        return this.getBooleanParameter(request, "trace");
    }

    protected boolean getMessageParameter(RequestContext request) {
        return this.getBooleanParameter(request, "message");
    }

    protected boolean getErrorsParameter(RequestContext request) {
        return this.getBooleanParameter(request, "errors");
    }

    protected boolean getPathParameter(RequestContext request) {
        return this.getBooleanParameter(request, "path");
    }

    protected boolean getBooleanParameter(RequestContext request, String parameterName) {
        String parameter = request.getParameter(parameterName);
        if (parameter == null) {
            return false;
        }
        return !"false".equalsIgnoreCase(parameter);
    }

    protected HttpStatus getStatus(RequestContext request) {
        int statusCode = request.getStatus();
        try {
            return HttpStatus.valueOf(statusCode);
        }
        catch (Exception ex) {
            return HttpStatus.INTERNAL_SERVER_ERROR;
        }
    }

    protected ModelAndView resolveErrorView(RequestContext request, HttpStatusCode status, Map<String, Object> model) {
        for (ErrorViewResolver resolver : this.errorViewResolvers) {
            ModelAndView view = resolver.resolveErrorView(request, status, model);
            if (view == null) continue;
            return view;
        }
        return new ModelAndView("error", model);
    }

    protected ErrorAttributeOptions getErrorAttributeOptions(RequestContext request, MediaType mediaType) {
        ErrorAttributeOptions options = ErrorAttributeOptions.defaults();
        if (this.errorProperties.includeException) {
            options = options.including(ErrorAttributeOptions.Include.EXCEPTION);
        }
        if (this.isIncludeStackTrace(request, mediaType)) {
            options = options.including(ErrorAttributeOptions.Include.STACK_TRACE);
        }
        if (this.isIncludeMessage(request, mediaType)) {
            options = options.including(ErrorAttributeOptions.Include.MESSAGE);
        }
        if (this.isIncludeBindingErrors(request, mediaType)) {
            options = options.including(ErrorAttributeOptions.Include.BINDING_ERRORS);
        }
        options = this.isIncludePath(request, mediaType) ? options.including(ErrorAttributeOptions.Include.PATH) : options.excluding(ErrorAttributeOptions.Include.PATH);
        return options;
    }

    protected boolean isIncludeStackTrace(RequestContext request, MediaType produces) {
        return switch (this.errorProperties.includeStacktrace) {
            case IncludeAttribute.ALWAYS -> true;
            case IncludeAttribute.ON_PARAM -> this.getTraceParameter(request);
            default -> false;
        };
    }

    protected boolean isIncludeMessage(RequestContext request, MediaType produces) {
        return switch (this.errorProperties.includeMessage) {
            case IncludeAttribute.ALWAYS -> true;
            case IncludeAttribute.ON_PARAM -> this.getMessageParameter(request);
            default -> false;
        };
    }

    protected boolean isIncludeBindingErrors(RequestContext request, MediaType produces) {
        return switch (this.errorProperties.includeBindingErrors) {
            case IncludeAttribute.ALWAYS -> true;
            case IncludeAttribute.ON_PARAM -> this.getErrorsParameter(request);
            default -> false;
        };
    }

    protected boolean isIncludePath(RequestContext request, MediaType produces) {
        return switch (this.errorProperties.includePath) {
            default -> throw new IncompatibleClassChangeError();
            case IncludeAttribute.ALWAYS -> true;
            case IncludeAttribute.ON_PARAM -> this.getPathParameter(request);
            case IncludeAttribute.NEVER -> false;
        };
    }
}

