/*
 * Decompiled with CFR 0.152.
 */
package infra.web.server.context;

import infra.context.ApplicationContext;
import infra.context.ApplicationListener;
import infra.lang.Assert;
import infra.logging.Logger;
import infra.logging.LoggerFactory;
import infra.util.FileCopyUtils;
import infra.util.StringUtils;
import infra.web.server.context.WebServerApplicationContext;
import infra.web.server.context.WebServerInitializedEvent;
import java.io.File;
import java.util.Locale;

public class WebServerPortFileWriter
implements ApplicationListener<WebServerInitializedEvent> {
    private static final String DEFAULT_FILE_NAME = "application.port";
    private static final String[] PROPERTY_VARIABLES = new String[]{"PORTFILE", "portfile"};
    private static final Logger logger = LoggerFactory.getLogger(WebServerPortFileWriter.class);
    private final File file;

    public WebServerPortFileWriter() {
        this(new File(DEFAULT_FILE_NAME));
    }

    public WebServerPortFileWriter(String filename) {
        this(new File(filename));
    }

    public WebServerPortFileWriter(File file) {
        Assert.notNull((Object)file, (String)"File is required");
        String override = WebServerPortFileWriter.getSystemProperties(PROPERTY_VARIABLES);
        this.file = override != null ? new File(override) : file;
    }

    public void onApplicationEvent(WebServerInitializedEvent event) {
        File portFile = this.getPortFile(event.getApplicationContext());
        try {
            String port = String.valueOf(event.getWebServer().getPort());
            this.createParentDirectory(portFile);
            FileCopyUtils.copy((byte[])port.getBytes(), (File)portFile);
            portFile.deleteOnExit();
        }
        catch (Exception ex) {
            logger.warn("Cannot create port file {}", (Object)this.file);
        }
    }

    protected File getPortFile(ApplicationContext applicationContext) {
        String namespace = this.getServerNamespace(applicationContext);
        if (StringUtils.isEmpty((CharSequence)namespace)) {
            return this.file;
        }
        Object name = this.file.getName();
        String extension = StringUtils.getFilenameExtension((String)this.file.getName());
        name = this.isUpperCase((String)(name = ((String)name).substring(0, ((String)name).length() - extension.length() - 1))) ? (String)name + "-" + namespace.toUpperCase(Locale.ROOT) : (String)name + "-" + namespace.toLowerCase(Locale.ROOT);
        if (StringUtils.isNotEmpty((CharSequence)extension)) {
            name = (String)name + "." + extension;
        }
        return new File(this.file.getParentFile(), (String)name);
    }

    private String getServerNamespace(ApplicationContext applicationContext) {
        if (applicationContext instanceof WebServerApplicationContext) {
            return ((WebServerApplicationContext)applicationContext).getServerNamespace();
        }
        return null;
    }

    private boolean isUpperCase(String name) {
        for (int i = 0; i < name.length(); ++i) {
            if (!Character.isLetter(name.charAt(i)) || Character.isUpperCase(name.charAt(i))) continue;
            return false;
        }
        return true;
    }

    private void createParentDirectory(File file) {
        File parent = file.getParentFile();
        if (parent != null) {
            parent.mkdirs();
        }
    }

    public static String getSystemProperties(String ... properties) {
        for (String property : properties) {
            try {
                String override = System.getProperty(property);
                String string = override = override != null ? override : System.getenv(property);
                if (override == null) continue;
                return override;
            }
            catch (Throwable ex) {
                System.err.printf("Could not resolve '%s' as system property: %s%n", property, ex);
            }
        }
        return null;
    }
}

