/*
 * Decompiled with CFR 0.152.
 */
package infra.web.server.context;

import infra.context.SmartLifecycle;
import infra.web.server.WebServer;

public final class WebServerGracefulShutdownLifecycle
implements SmartLifecycle {
    public static final int SMART_LIFECYCLE_PHASE = 0x7FFFFBFF;
    private final WebServer webServer;
    private volatile boolean running;

    public WebServerGracefulShutdownLifecycle(WebServer webServer) {
        this.webServer = webServer;
    }

    public void start() {
        this.running = true;
    }

    public void stop() {
        throw new UnsupportedOperationException("Stop must not be invoked directly");
    }

    public void stop(Runnable callback) {
        this.running = false;
        this.webServer.shutDownGracefully(result -> callback.run());
    }

    public boolean isRunning() {
        return this.running;
    }

    public int getPhase() {
        return 0x7FFFFBFF;
    }
}

