/*
 * Decompiled with CFR 0.152.
 */
package infra.web.server.context;

import infra.beans.BeansException;
import infra.beans.factory.NoSuchBeanDefinitionException;
import infra.beans.factory.config.ConfigurableBeanFactory;
import infra.beans.factory.support.StandardBeanFactory;
import infra.context.ApplicationContextException;
import infra.context.support.GenericApplicationContext;
import infra.lang.Nullable;
import infra.util.CollectionUtils;
import infra.util.StringUtils;
import infra.web.RequestContextUtils;
import infra.web.server.ChannelWebServerFactory;
import infra.web.server.WebServer;
import infra.web.server.context.ConfigurableWebServerApplicationContext;
import infra.web.server.context.MissingWebServerFactoryBeanException;
import infra.web.server.context.WebServerGracefulShutdownLifecycle;
import infra.web.server.context.WebServerStartStopLifecycle;
import io.netty.channel.ChannelHandler;
import java.util.Collection;
import java.util.Set;

public class GenericWebServerApplicationContext
extends GenericApplicationContext
implements ConfigurableWebServerApplicationContext {
    @Nullable
    private String serverNamespace;
    @Nullable
    private volatile WebServer webServer;

    public GenericWebServerApplicationContext() {
    }

    public GenericWebServerApplicationContext(StandardBeanFactory beanFactory) {
        super(beanFactory);
    }

    public final void refresh() throws BeansException, IllegalStateException {
        try {
            super.refresh();
        }
        catch (RuntimeException ex) {
            WebServer webServer = this.webServer;
            if (webServer != null) {
                webServer.stop();
            }
            throw ex;
        }
    }

    protected void onRefresh() {
        super.onRefresh();
        try {
            if (this.webServer == null) {
                this.webServer = this.createWebServer();
            }
        }
        catch (Throwable ex) {
            throw new ApplicationContextException("Unable to start web server", ex);
        }
    }

    protected WebServer createWebServer() {
        ChannelHandler channelHandler = this.getChannelHandler();
        ChannelWebServerFactory factory = this.getWebServerFactory();
        WebServer webServer = factory.getWebServer(channelHandler);
        this.beanFactory.registerSingleton("webServerStartStop", (Object)new WebServerStartStopLifecycle(this, webServer));
        this.beanFactory.registerSingleton("webServerGracefulShutdown", (Object)new WebServerGracefulShutdownLifecycle(webServer));
        return webServer;
    }

    private ChannelWebServerFactory getWebServerFactory() {
        Set beanNames = this.beanFactory.getBeanNamesForType(ChannelWebServerFactory.class);
        if (beanNames.isEmpty()) {
            throw new MissingWebServerFactoryBeanException(this.getClass(), ChannelWebServerFactory.class);
        }
        if (beanNames.size() > 1) {
            throw new ApplicationContextException("Unable to start WebServerApplicationContext due to multiple WebServerFactory beans : " + StringUtils.collectionToCommaDelimitedString((Collection)beanNames));
        }
        return (ChannelWebServerFactory)this.beanFactory.getBean((String)CollectionUtils.firstElement((Iterable)beanNames), ChannelWebServerFactory.class);
    }

    protected ChannelHandler getChannelHandler() {
        try {
            return (ChannelHandler)this.beanFactory.getBean("nettyChannelHandler", ChannelHandler.class);
        }
        catch (NoSuchBeanDefinitionException e) {
            throw new ApplicationContextException("Unable to start WebServerApplicationContext due to missing ChannelHandler bean.");
        }
    }

    @Override
    @Nullable
    public WebServer getWebServer() {
        return this.webServer;
    }

    @Override
    public void setServerNamespace(@Nullable String serverNamespace) {
        this.serverNamespace = serverNamespace;
    }

    @Override
    @Nullable
    public String getServerNamespace() {
        return this.serverNamespace;
    }

    protected void postProcessBeanFactory(ConfigurableBeanFactory beanFactory) {
        super.postProcessBeanFactory(beanFactory);
        RequestContextUtils.registerScopes(beanFactory);
    }
}

