/*
 * Decompiled with CFR 0.152.
 */
package infra.web.server;

import infra.core.ssl.NoSuchSslBundleException;
import infra.core.ssl.SslBundle;
import infra.core.ssl.SslBundleKey;
import infra.core.ssl.SslBundles;
import infra.core.ssl.SslManagerBundle;
import infra.core.ssl.SslOptions;
import infra.core.ssl.SslStoreBundle;
import infra.core.ssl.jks.JksSslStoreBundle;
import infra.core.ssl.jks.JksSslStoreDetails;
import infra.core.ssl.pem.PemSslStoreBundle;
import infra.core.ssl.pem.PemSslStoreDetails;
import infra.core.style.ToStringBuilder;
import infra.lang.Assert;
import infra.lang.Nullable;
import infra.util.StringUtils;
import infra.web.server.Ssl;
import java.security.KeyStore;

public final class WebServerSslBundle
implements SslBundle {
    private final SslStoreBundle stores;
    private final SslBundleKey key;
    private final SslOptions options;
    private final String protocol;
    private final SslManagerBundle managers;

    private WebServerSslBundle(SslStoreBundle stores, @Nullable String keyPassword, Ssl ssl) {
        this.stores = stores;
        this.protocol = ssl.protocol;
        this.key = SslBundleKey.of((String)keyPassword, (String)ssl.keyAlias);
        this.options = SslOptions.of((String[])ssl.ciphers, (String[])ssl.enabledProtocols);
        this.managers = SslManagerBundle.from((SslStoreBundle)this.stores, (SslBundleKey)this.key);
    }

    private static SslStoreBundle createPemKeyStoreBundle(Ssl ssl) {
        PemSslStoreDetails keyStoreDetails = new PemSslStoreDetails(ssl.keyStoreType, ssl.certificate, ssl.certificatePrivateKey).withAlias(ssl.keyAlias);
        return new PemSslStoreBundle(keyStoreDetails, null);
    }

    private static SslStoreBundle createPemTrustStoreBundle(Ssl ssl) {
        PemSslStoreDetails trustStoreDetails = new PemSslStoreDetails(ssl.trustStoreType, ssl.trustCertificate, ssl.trustCertificatePrivateKey).withAlias(ssl.keyAlias);
        return new PemSslStoreBundle(null, trustStoreDetails);
    }

    private static SslStoreBundle createJksKeyStoreBundle(Ssl ssl) {
        JksSslStoreDetails keyStoreDetails = new JksSslStoreDetails(ssl.keyStoreType, ssl.keyStoreProvider, ssl.keyStore, ssl.keyStorePassword);
        return new JksSslStoreBundle(keyStoreDetails, null);
    }

    private static SslStoreBundle createJksTrustStoreBundle(Ssl ssl) {
        JksSslStoreDetails trustStoreDetails = new JksSslStoreDetails(ssl.trustStoreType, ssl.trustStoreProvider, ssl.trustStore, ssl.trustStorePassword);
        return new JksSslStoreBundle(null, trustStoreDetails);
    }

    public SslStoreBundle getStores() {
        return this.stores;
    }

    public SslBundleKey getKey() {
        return this.key;
    }

    public SslOptions getOptions() {
        return this.options;
    }

    public String getProtocol() {
        return this.protocol;
    }

    public SslManagerBundle getManagers() {
        return this.managers;
    }

    public static SslBundle get(Ssl ssl) throws NoSuchSslBundleException {
        return WebServerSslBundle.get(ssl, null);
    }

    public static SslBundle get(@Nullable Ssl ssl, @Nullable SslBundles sslBundles) throws NoSuchSslBundleException {
        Assert.state((boolean)Ssl.isEnabled(ssl), (String)"SSL is not enabled");
        String bundleName = ssl.bundle;
        if (StringUtils.hasText((String)bundleName)) {
            if (sslBundles == null) {
                throw new IllegalStateException("SSL bundle '%s' was requested but no SslBundles instance was provided".formatted(bundleName));
            }
            return sslBundles.getBundle(bundleName);
        }
        SslStoreBundle stores = WebServerSslBundle.createStoreBundle(ssl);
        String keyPassword = ssl.keyPassword;
        return new WebServerSslBundle(stores, keyPassword, ssl);
    }

    private static SslStoreBundle createStoreBundle(Ssl ssl) {
        KeyStore keyStore = WebServerSslBundle.createKeyStore(ssl);
        KeyStore trustStore = WebServerSslBundle.createTrustStore(ssl);
        return new WebServerSslStoreBundle(keyStore, trustStore, ssl.keyStorePassword);
    }

    @Nullable
    private static KeyStore createKeyStore(Ssl ssl) {
        if (WebServerSslBundle.hasPemKeyStoreProperties(ssl)) {
            return WebServerSslBundle.createPemKeyStoreBundle(ssl).getKeyStore();
        }
        if (WebServerSslBundle.hasJksKeyStoreProperties(ssl)) {
            return WebServerSslBundle.createJksKeyStoreBundle(ssl).getKeyStore();
        }
        return null;
    }

    @Nullable
    private static KeyStore createTrustStore(Ssl ssl) {
        if (WebServerSslBundle.hasPemTrustStoreProperties(ssl)) {
            return WebServerSslBundle.createPemTrustStoreBundle(ssl).getTrustStore();
        }
        if (WebServerSslBundle.hasJksTrustStoreProperties(ssl)) {
            return WebServerSslBundle.createJksTrustStoreBundle(ssl).getTrustStore();
        }
        return null;
    }

    private static boolean hasPemKeyStoreProperties(Ssl ssl) {
        return Ssl.isEnabled(ssl) && ssl.certificate != null && ssl.certificatePrivateKey != null;
    }

    private static boolean hasPemTrustStoreProperties(Ssl ssl) {
        return Ssl.isEnabled(ssl) && ssl.trustCertificate != null;
    }

    private static boolean hasJksKeyStoreProperties(Ssl ssl) {
        return Ssl.isEnabled(ssl) && (ssl.keyStore != null || ssl.keyStoreType != null && ssl.keyStoreType.equals("PKCS11"));
    }

    private static boolean hasJksTrustStoreProperties(Ssl ssl) {
        return Ssl.isEnabled(ssl) && (ssl.trustStore != null || ssl.trustStoreType != null && ssl.trustStoreType.equals("PKCS11"));
    }

    public String toString() {
        ToStringBuilder creator = new ToStringBuilder((Object)this);
        creator.append("key", (Object)this.key);
        creator.append("protocol", (Object)this.protocol);
        creator.append("stores", (Object)this.stores);
        creator.append("options", (Object)this.options);
        return creator.toString();
    }

    private static final class WebServerSslStoreBundle
    implements SslStoreBundle {
        @Nullable
        private final KeyStore keyStore;
        @Nullable
        private final KeyStore trustStore;
        @Nullable
        private final String keyStorePassword;

        private WebServerSslStoreBundle(@Nullable KeyStore keyStore, @Nullable KeyStore trustStore, @Nullable String keyStorePassword) {
            Assert.state((keyStore != null || trustStore != null ? 1 : 0) != 0, (String)"SSL is enabled but no trust material is configured");
            this.keyStore = keyStore;
            this.trustStore = trustStore;
            this.keyStorePassword = keyStorePassword;
        }

        @Nullable
        public KeyStore getKeyStore() {
            return this.keyStore;
        }

        @Nullable
        public KeyStore getTrustStore() {
            return this.trustStore;
        }

        @Nullable
        public String getKeyStorePassword() {
            return this.keyStorePassword;
        }

        public String toString() {
            ToStringBuilder creator = new ToStringBuilder((Object)this);
            creator.append("keyStore.type", (Object)(this.keyStore != null ? this.keyStore.getType() : "none"));
            creator.append("keyStorePassword", (Object)(this.keyStorePassword != null ? "******" : null));
            creator.append("trustStore.type", (Object)(this.trustStore != null ? this.trustStore.getType() : "none"));
            return creator.toString();
        }
    }
}

