/*
 * Decompiled with CFR 0.152.
 */
package infra.web.server;

import infra.lang.Nullable;
import java.time.Duration;
import java.util.ArrayList;
import java.util.List;

public class Ssl {
    public boolean enabled = true;
    @Nullable
    public String bundle;
    @Nullable
    public String keyAlias;
    @Nullable
    public String keyStore;
    @Nullable
    public String keyStorePassword;
    @Nullable
    public String keyStoreType;
    @Nullable
    public String keyStoreProvider;
    @Nullable
    public String trustStore;
    @Nullable
    public String trustStorePassword;
    @Nullable
    public String trustStoreType;
    @Nullable
    public String trustStoreProvider;
    @Nullable
    public String certificate;
    @Nullable
    public String certificatePrivateKey;
    @Nullable
    public String trustCertificate;
    @Nullable
    public String trustCertificatePrivateKey;
    public String protocol = "TLS";
    @Nullable
    public String keyPassword;
    @Nullable
    public String[] ciphers;
    @Nullable
    public String[] enabledProtocols;
    @Nullable
    public ClientAuth clientAuth;
    public Duration handshakeTimeout = Duration.ofSeconds(10L);
    public final List<ServerNameSslBundle> serverNameBundles = new ArrayList<ServerNameSslBundle>();

    public static boolean isEnabled(@Nullable Ssl ssl) {
        return ssl != null && ssl.enabled;
    }

    public static Ssl forBundle(@Nullable String bundle) {
        Ssl ssl = new Ssl();
        ssl.bundle = bundle;
        return ssl;
    }

    public static enum ClientAuth {
        NONE,
        WANT,
        NEED;


        public static <R> R map(@Nullable ClientAuth clientAuth, R none, R want, R need) {
            return switch (clientAuth != null ? clientAuth : NONE) {
                default -> throw new IncompatibleClassChangeError();
                case NONE -> none;
                case WANT -> want;
                case NEED -> need;
            };
        }
    }

    public static class ServerNameSslBundle {
        private String serverName;
        private String bundle;

        public void setBundle(String bundle) {
            this.bundle = bundle;
        }

        public void setServerName(String serverName) {
            this.serverName = serverName;
        }

        public String getBundle() {
            return this.bundle;
        }

        public String getServerName() {
            return this.serverName;
        }
    }
}

