/*
 * Decompiled with CFR 0.152.
 */
package infra.web.server;

import infra.context.properties.ConfigurationProperties;
import infra.context.properties.NestedConfigurationProperty;
import infra.core.ApplicationTemp;
import infra.core.ssl.SslBundles;
import infra.lang.Nullable;
import infra.util.DataSize;
import infra.web.server.Compression;
import infra.web.server.ConfigurableWebServerFactory;
import infra.web.server.EncodingProperties;
import infra.web.server.Http2;
import infra.web.server.Shutdown;
import infra.web.server.Ssl;
import infra.web.server.error.ErrorProperties;
import io.netty.channel.socket.ServerSocketChannel;
import io.netty.handler.logging.LogLevel;
import java.net.InetAddress;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.time.Duration;
import java.util.concurrent.TimeUnit;

@ConfigurationProperties(prefix="server", ignoreUnknownFields=true)
public class ServerProperties {
    @Nullable
    public Integer port;
    @Nullable
    public InetAddress address;
    @NestedConfigurationProperty
    public final EncodingProperties encoding = new EncodingProperties();
    @NestedConfigurationProperty
    public final ErrorProperties error = new ErrorProperties();
    @Nullable
    public ForwardHeadersStrategy forwardHeadersStrategy;
    @Nullable
    public Shutdown shutdown = Shutdown.GRACEFUL;
    @Nullable
    @NestedConfigurationProperty
    public Ssl ssl;
    @Nullable
    @NestedConfigurationProperty
    public Compression compression;
    @Nullable
    @NestedConfigurationProperty
    public Http2 http2;
    @NestedConfigurationProperty
    public final Netty netty = new Netty();
    @NestedConfigurationProperty
    public final ReactorNetty reactorNetty = new ReactorNetty();

    public void applyTo(ConfigurableWebServerFactory factory, @Nullable SslBundles sslBundles, @Nullable ApplicationTemp applicationTemp) {
        if (sslBundles != null) {
            factory.setSslBundles(sslBundles);
        }
        if (applicationTemp != null) {
            factory.setApplicationTemp(applicationTemp);
        }
        if (this.ssl != null) {
            factory.setSsl(this.ssl);
        }
        if (this.port != null) {
            factory.setPort(this.port);
        }
        factory.setHttp2(this.http2);
        if (this.address != null) {
            factory.setAddress(this.address);
        }
        if (this.shutdown != null) {
            factory.setShutdown(this.shutdown);
        }
        factory.setCompression(this.compression);
    }

    public static class Netty {
        @Nullable
        public Integer workerThreads;
        @Nullable
        public Integer acceptorThreads;
        @Nullable
        public String workerPoolName;
        @Nullable
        public String acceptorPoolName;
        @Nullable
        public Integer maxConnection;
        @Nullable
        public Class<? extends ServerSocketChannel> socketChannel;
        @Nullable
        public LogLevel loggingLevel;
        public DataSize maxContentLength = DataSize.ofMegabytes((long)100L);
        public DataSize maxChunkSize = DataSize.ofBytes((long)8192L);
        public DataSize initialBufferSize = DataSize.ofBytes((long)128L);
        public DataSize maxHeaderSize = DataSize.ofBytes((long)8192L);
        public int maxInitialLineLength = 4096;
        public boolean validateHeaders = true;
        public boolean closeOnExpectationFailed = false;
        public boolean chunkedSupported = true;
        public boolean allowPartialChunks = true;
        public boolean allowDuplicateContentLengths = false;
        @NestedConfigurationProperty
        public final Shutdown shutdown = new Shutdown();
        @NestedConfigurationProperty
        public final Multipart multipart = new Multipart();

        public static class Shutdown {
            public long quietPeriod = 1L;
            public long timeout = 10L;
            public TimeUnit unit = TimeUnit.SECONDS;
        }

        public static class Multipart {
            @Nullable
            public String baseDir;
            public boolean deleteOnExit;
            @Nullable
            public DataSize fieldSizeThreshold = DataSize.ofKilobytes((long)16L);
            public boolean mixedMode = true;
            public Charset charset = StandardCharsets.UTF_8;
            @Nullable
            public DataSize maxFieldSize = DataSize.ofGigabytes((long)1L);
        }
    }

    public static class ReactorNetty {
        public Duration connectionTimeout;
        public DataSize h2cMaxContentLength = DataSize.ofBytes((long)0L);
        public DataSize initialBufferSize = DataSize.ofBytes((long)128L);
        public DataSize maxChunkSize = DataSize.ofKilobytes((long)8L);
        public DataSize maxHeaderSize = DataSize.ofKilobytes((long)8L);
        public DataSize maxInitialLineLength = DataSize.ofKilobytes((long)4L);
        public Integer maxKeepAliveRequests;
        public boolean validateHeaders = true;
        public Duration idleTimeout;
    }

    public static enum ForwardHeadersStrategy {
        NATIVE,
        FRAMEWORK,
        NONE;

    }
}

