/*
 * Decompiled with CFR 0.152.
 */
package infra.web.server;

import infra.lang.Nullable;
import infra.web.server.WebServerException;
import java.net.BindException;
import java.util.Locale;
import java.util.function.Consumer;
import java.util.function.IntSupplier;

public class PortInUseException
extends WebServerException {
    private final int port;

    public PortInUseException(int port) {
        this(port, null);
    }

    public PortInUseException(int port, @Nullable Throwable cause) {
        super("Port %d is already in use".formatted(port), cause);
        this.port = port;
    }

    public int getPort() {
        return this.port;
    }

    public static void throwIfPortBindingException(Exception ex, IntSupplier port) {
        PortInUseException.ifPortBindingException(ex, bindException -> {
            throw new PortInUseException(port.getAsInt(), (Throwable)ex);
        });
    }

    public static void ifPortBindingException(Exception ex, Consumer<BindException> action) {
        PortInUseException.ifCausedBy(ex, BindException.class, bindException -> {
            if (bindException.getMessage().toLowerCase(Locale.ROOT).contains("in use")) {
                action.accept((BindException)bindException);
            }
        });
    }

    public static <E extends Exception> void ifCausedBy(Exception ex, Class<E> causedBy, Consumer<E> action) {
        for (Throwable candidate = ex; candidate != null; candidate = candidate.getCause()) {
            if (!causedBy.isInstance(candidate)) continue;
            action.accept(candidate);
            return;
        }
    }
}

