/*
 * Decompiled with CFR 0.152.
 */
package infra.web.server;

import infra.core.ApplicationTemp;
import infra.core.ssl.SslBundle;
import infra.core.ssl.SslBundles;
import infra.lang.Assert;
import infra.lang.Nullable;
import infra.util.StringUtils;
import infra.web.server.Compression;
import infra.web.server.ConfigurableWebServerFactory;
import infra.web.server.Http2;
import infra.web.server.Shutdown;
import infra.web.server.Ssl;
import infra.web.server.WebServerSslBundle;
import java.net.InetAddress;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.function.BiConsumer;

public abstract class AbstractConfigurableWebServerFactory
implements ConfigurableWebServerFactory {
    private int port = 8080;
    @Nullable
    private InetAddress address;
    @Nullable
    private Ssl ssl;
    @Nullable
    private SslBundles sslBundles;
    @Nullable
    private Http2 http2;
    @Nullable
    private Compression compression;
    private Shutdown shutdown = Shutdown.IMMEDIATE;
    private ApplicationTemp applicationTemp = ApplicationTemp.instance;

    public AbstractConfigurableWebServerFactory() {
    }

    public AbstractConfigurableWebServerFactory(int port) {
        this.port = port;
    }

    public int getPort() {
        return this.port;
    }

    @Override
    public void setPort(int port) {
        this.port = port;
    }

    @Nullable
    public InetAddress getAddress() {
        return this.address;
    }

    @Override
    public void setAddress(@Nullable InetAddress address) {
        this.address = address;
    }

    @Nullable
    public Ssl getSsl() {
        return this.ssl;
    }

    @Override
    public void setSsl(@Nullable Ssl ssl) {
        this.ssl = ssl;
    }

    @Nullable
    public SslBundles getSslBundles() {
        return this.sslBundles;
    }

    @Override
    public void setSslBundles(@Nullable SslBundles sslBundles) {
        this.sslBundles = sslBundles;
    }

    @Nullable
    public Http2 getHttp2() {
        return this.http2;
    }

    @Override
    public void setHttp2(@Nullable Http2 http2) {
        this.http2 = http2;
    }

    @Nullable
    public Compression getCompression() {
        return this.compression;
    }

    @Override
    public void setCompression(@Nullable Compression compression) {
        this.compression = compression;
    }

    @Override
    public void setShutdown(Shutdown shutdown) {
        this.shutdown = shutdown;
    }

    public Shutdown getShutdown() {
        return this.shutdown;
    }

    @Override
    public void setApplicationTemp(ApplicationTemp applicationTemp) {
        Assert.notNull((Object)applicationTemp, (String)"ApplicationTemp is required");
        this.applicationTemp = applicationTemp;
    }

    public ApplicationTemp getApplicationTemp() {
        return this.applicationTemp;
    }

    protected final boolean isHttp2Enabled() {
        return Http2.isEnabled(this.getHttp2());
    }

    protected final SslBundle getSslBundle() {
        return WebServerSslBundle.get(this.ssl, this.sslBundles);
    }

    protected final Map<String, SslBundle> getServerNameSslBundles() {
        if (this.ssl != null && !this.ssl.serverNameBundles.isEmpty()) {
            Assert.state((this.sslBundles != null ? 1 : 0) != 0, (String)"sslBundles is required");
            HashMap<String, SslBundle> ret = new HashMap<String, SslBundle>();
            for (Ssl.ServerNameSslBundle pair : this.ssl.serverNameBundles) {
                ret.put(pair.getServerName(), this.sslBundles.getBundle(pair.getBundle()));
            }
            return ret;
        }
        return Collections.emptyMap();
    }

    protected final void addBundleUpdateHandler(Ssl ssl, BiConsumer<String, SslBundle> updateHandler) {
        if (this.sslBundles != null) {
            this.addBundleUpdateHandler(this.sslBundles, null, ssl.bundle, updateHandler);
            for (Ssl.ServerNameSslBundle pair : ssl.serverNameBundles) {
                this.addBundleUpdateHandler(this.sslBundles, pair.getServerName(), pair.getBundle(), updateHandler);
            }
        }
    }

    private void addBundleUpdateHandler(SslBundles sslBundles, @Nullable String serverName, @Nullable String bundleName, BiConsumer<String, SslBundle> updateHandler) {
        if (StringUtils.hasText((String)bundleName)) {
            sslBundles.addBundleUpdateHandler(bundleName, sslBundle -> updateHandler.accept(serverName, (SslBundle)sslBundle));
        }
    }
}

