/*
 * Decompiled with CFR 0.152.
 */
package infra.web.resource;

import infra.core.AntPathMatcher;
import infra.core.io.AbstractResource;
import infra.core.io.Resource;
import infra.core.io.ResourceFilter;
import infra.http.DefaultHttpHeaders;
import infra.http.HttpHeaders;
import infra.lang.Assert;
import infra.lang.Nullable;
import infra.util.StringUtils;
import infra.web.RequestContext;
import infra.web.resource.AbstractResourceResolver;
import infra.web.resource.ContentVersionStrategy;
import infra.web.resource.FixedVersionStrategy;
import infra.web.resource.HttpResource;
import infra.web.resource.ResourceResolvingChain;
import infra.web.resource.VersionStrategy;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.net.URI;
import java.net.URL;
import java.nio.channels.ReadableByteChannel;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

public class VersionResourceResolver
extends AbstractResourceResolver {
    private final AntPathMatcher pathMatcher = new AntPathMatcher();
    private final LinkedHashMap<String, VersionStrategy> versionStrategyMap = new LinkedHashMap();

    public void setStrategyMap(Map<String, VersionStrategy> map) {
        this.versionStrategyMap.clear();
        this.versionStrategyMap.putAll(map);
    }

    public Map<String, VersionStrategy> getStrategyMap() {
        return this.versionStrategyMap;
    }

    public VersionResourceResolver addContentVersionStrategy(String ... pathPatterns) {
        this.addVersionStrategy(new ContentVersionStrategy(), pathPatterns);
        return this;
    }

    public VersionResourceResolver addFixedVersionStrategy(String version, String ... pathPatterns) {
        List<String> patternsList = Arrays.asList(pathPatterns);
        ArrayList<Object> prefixedPatterns = new ArrayList<Object>(pathPatterns.length);
        String versionPrefix = "/" + version;
        for (String pattern : patternsList) {
            prefixedPatterns.add(pattern);
            if (pattern.startsWith(versionPrefix) || patternsList.contains(versionPrefix + pattern)) continue;
            prefixedPatterns.add(versionPrefix + pattern);
        }
        return this.addVersionStrategy(new FixedVersionStrategy(version), StringUtils.toStringArray(prefixedPatterns));
    }

    public VersionResourceResolver addVersionStrategy(VersionStrategy strategy, String ... pathPatterns) {
        for (String pattern : pathPatterns) {
            this.getStrategyMap().put(pattern, strategy);
        }
        return this;
    }

    @Override
    protected Resource resolveResourceInternal(@Nullable RequestContext request, String requestPath, List<? extends Resource> locations, ResourceResolvingChain chain) {
        Resource resolved = chain.resolveResource(request, requestPath, locations);
        if (resolved != null) {
            return resolved;
        }
        VersionStrategy versionStrategy = this.getStrategyForPath(requestPath);
        if (versionStrategy == null) {
            return null;
        }
        String candidateVersion = versionStrategy.extractVersion(requestPath);
        if (StringUtils.isEmpty((CharSequence)candidateVersion)) {
            return null;
        }
        String simplePath = versionStrategy.removeVersion(requestPath, candidateVersion);
        Resource baseResource = chain.resolveResource(request, simplePath, locations);
        if (baseResource == null) {
            return null;
        }
        String actualVersion = versionStrategy.getResourceVersion(baseResource);
        if (candidateVersion.equals(actualVersion)) {
            return new FileNameVersionedResource(baseResource, candidateVersion);
        }
        if (this.logger.isTraceEnabled()) {
            this.logger.trace("Found resource for \"{}\", but version [{}] does not match", (Object)requestPath, (Object)candidateVersion);
        }
        return null;
    }

    @Override
    protected String resolveUrlPathInternal(String resourceUrlPath, List<? extends Resource> locations, ResourceResolvingChain chain) {
        String baseUrl = chain.resolveUrlPath(resourceUrlPath, locations);
        if (StringUtils.hasText((String)baseUrl)) {
            VersionStrategy versionStrategy = this.getStrategyForPath(resourceUrlPath);
            if (versionStrategy == null) {
                return baseUrl;
            }
            Resource resource = chain.resolveResource(null, baseUrl, locations);
            Assert.state((resource != null ? 1 : 0) != 0, (String)"Unresolvable resource");
            String version = versionStrategy.getResourceVersion(resource);
            return versionStrategy.addVersion(baseUrl, version);
        }
        return baseUrl;
    }

    @Nullable
    protected VersionStrategy getStrategyForPath(String requestPath) {
        String path = "/".concat(requestPath);
        ArrayList<String> matchingPatterns = new ArrayList<String>();
        for (String pattern : this.versionStrategyMap.keySet()) {
            if (!this.pathMatcher.match(pattern, path)) continue;
            matchingPatterns.add(pattern);
        }
        if (!matchingPatterns.isEmpty()) {
            Comparator comparator = this.pathMatcher.getPatternComparator(path);
            matchingPatterns.sort(comparator);
            return this.versionStrategyMap.get(matchingPatterns.get(0));
        }
        return null;
    }

    private static class FileNameVersionedResource
    extends AbstractResource
    implements HttpResource {
        private final Resource original;
        private final String version;

        public FileNameVersionedResource(Resource original, String version) {
            this.original = original;
            this.version = version;
        }

        public boolean exists() {
            return this.original.exists();
        }

        public boolean isReadable() {
            return this.original.isReadable();
        }

        public boolean isOpen() {
            return this.original.isOpen();
        }

        public URL getURL() throws IOException {
            return this.original.getURL();
        }

        public URI getURI() throws IOException {
            return this.original.getURI();
        }

        public File getFile() throws IOException {
            return this.original.getFile();
        }

        @Nullable
        public String getName() {
            return this.original.getName();
        }

        public long contentLength() throws IOException {
            return this.original.contentLength();
        }

        public long lastModified() throws IOException {
            return this.original.lastModified();
        }

        public Resource createRelative(String relativePath) throws IOException {
            return this.original.createRelative(relativePath);
        }

        public InputStream getInputStream() throws IOException {
            return this.original.getInputStream();
        }

        public ReadableByteChannel readableChannel() throws IOException {
            return this.original.readableChannel();
        }

        public byte[] getContentAsByteArray() throws IOException {
            return this.original.getContentAsByteArray();
        }

        public String getContentAsString(Charset charset) throws IOException {
            return this.original.getContentAsString(charset);
        }

        public Reader getReader() throws IOException {
            return this.original.getReader();
        }

        public Reader getReader(String encoding) throws IOException {
            return this.original.getReader(encoding);
        }

        public boolean isFile() {
            return this.original.isFile();
        }

        public boolean isDirectory() throws IOException {
            return this.original.isDirectory();
        }

        public String[] list() throws IOException {
            return this.original.list();
        }

        public Resource[] list(@Nullable ResourceFilter filter) throws IOException {
            return this.original.list(filter);
        }

        @Override
        public HttpHeaders getResponseHeaders() {
            HttpHeaders httpHeaders;
            Resource resource = this.original;
            if (resource instanceof HttpResource) {
                HttpResource hr = (HttpResource)resource;
                httpHeaders = hr.getResponseHeaders();
            } else {
                httpHeaders = HttpHeaders.forWritable();
            }
            DefaultHttpHeaders headers = httpHeaders;
            headers.setETag("W/\"%s\"".formatted(this.version));
            return headers;
        }
    }
}

