/*
 * Decompiled with CFR 0.152.
 */
package infra.web.resource;

import infra.context.ApplicationContext;
import infra.context.ApplicationContextAware;
import infra.context.ApplicationListener;
import infra.context.event.ContextRefreshedEvent;
import infra.context.support.ApplicationObjectSupport;
import infra.core.AntPathMatcher;
import infra.core.PathMatcher;
import infra.core.annotation.AnnotationAwareOrderComparator;
import infra.lang.Nullable;
import infra.util.StringUtils;
import infra.web.RequestContext;
import infra.web.handler.SimpleUrlHandlerMapping;
import infra.web.resource.DefaultResourceResolvingChain;
import infra.web.resource.ResourceHttpRequestHandler;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.LinkedHashMap;
import java.util.Map;

public class ResourceUrlProvider
extends ApplicationObjectSupport
implements ApplicationListener<ContextRefreshedEvent>,
ApplicationContextAware {
    private PathMatcher pathMatcher = new AntPathMatcher();
    private final Map<String, ResourceHttpRequestHandler> handlerMap = new LinkedHashMap<String, ResourceHttpRequestHandler>();
    private boolean autodetect = true;

    public void setPathMatcher(PathMatcher pathMatcher) {
        this.pathMatcher = pathMatcher;
    }

    public PathMatcher getPathMatcher() {
        return this.pathMatcher;
    }

    public void setHandlerMap(@Nullable Map<String, ResourceHttpRequestHandler> handlerMap) {
        if (handlerMap != null) {
            this.handlerMap.clear();
            this.handlerMap.putAll(handlerMap);
            this.autodetect = false;
        }
    }

    public Map<String, ResourceHttpRequestHandler> getHandlerMap() {
        return this.handlerMap;
    }

    public boolean isAutodetect() {
        return this.autodetect;
    }

    public void onApplicationEvent(ContextRefreshedEvent event) {
        if (event.getApplicationContext() == this.applicationContext && this.isAutodetect()) {
            this.handlerMap.clear();
            this.detectResourceHandlers(this.applicationContext);
            if (!this.handlerMap.isEmpty()) {
                this.autodetect = false;
            }
        }
    }

    protected void detectResourceHandlers(ApplicationContext appContext) {
        Map beans = appContext.getBeansOfType(SimpleUrlHandlerMapping.class);
        ArrayList mappings = new ArrayList(beans.values());
        AnnotationAwareOrderComparator.sort(mappings);
        for (SimpleUrlHandlerMapping mapping : mappings) {
            for (String pattern : mapping.getHandlerMap().keySet()) {
                Object handler = mapping.getHandlerMap().get(pattern);
                if (!(handler instanceof ResourceHttpRequestHandler)) continue;
                ResourceHttpRequestHandler resourceHandler = (ResourceHttpRequestHandler)handler;
                this.handlerMap.put(pattern, resourceHandler);
            }
        }
        if (this.handlerMap.isEmpty()) {
            this.logger.trace("No resource handling mappings found");
        }
    }

    @Nullable
    public final String getForRequestUrl(RequestContext request, String requestUrl) {
        int suffixIndex;
        int prefixIndex = this.getLookupPathIndex(request);
        if (prefixIndex >= (suffixIndex = this.getEndPathIndex(requestUrl))) {
            return null;
        }
        String prefix = requestUrl.substring(0, prefixIndex);
        String suffix = requestUrl.substring(suffixIndex);
        String lookupPath = requestUrl.substring(prefixIndex, suffixIndex);
        String resolvedLookupPath = this.getForLookupPath(lookupPath);
        return resolvedLookupPath != null ? prefix + resolvedLookupPath + suffix : null;
    }

    private int getLookupPathIndex(RequestContext request) {
        String requestUri = request.getRequestURI();
        String lookupPath = request.getRequestPath().value();
        return requestUri.indexOf(lookupPath);
    }

    private int getEndPathIndex(String lookupPath) {
        int hashIndex;
        int suffixIndex = lookupPath.length();
        int queryIndex = lookupPath.indexOf(63);
        if (queryIndex > 0) {
            suffixIndex = queryIndex;
        }
        if ((hashIndex = lookupPath.indexOf(35)) > 0) {
            suffixIndex = Math.min(suffixIndex, hashIndex);
        }
        return suffixIndex;
    }

    @Nullable
    public final String getForLookupPath(String lookupPath) {
        String previous;
        do {
            previous = lookupPath;
        } while (!(lookupPath = StringUtils.replace((String)lookupPath, (String)"//", (String)"/")).equals(previous));
        ArrayList<String> matchingPatterns = new ArrayList<String>();
        PathMatcher pathMatcher = this.getPathMatcher();
        for (String pattern : this.handlerMap.keySet()) {
            if (!pathMatcher.match(pattern, lookupPath)) continue;
            matchingPatterns.add(pattern);
        }
        if (!matchingPatterns.isEmpty()) {
            Comparator patternComparator = pathMatcher.getPatternComparator(lookupPath);
            matchingPatterns.sort(patternComparator);
            for (String pattern : matchingPatterns) {
                String pathWithinMapping = pathMatcher.extractPathWithinPattern(pattern, lookupPath);
                String pathMapping = lookupPath.substring(0, lookupPath.indexOf(pathWithinMapping));
                ResourceHttpRequestHandler handler = this.handlerMap.get(pattern);
                DefaultResourceResolvingChain chain = new DefaultResourceResolvingChain(handler.getResourceResolvers());
                String resolved = chain.resolveUrlPath(pathWithinMapping, handler.getLocations());
                if (resolved == null) continue;
                return pathMapping + resolved;
            }
        }
        if (this.logger.isTraceEnabled()) {
            this.logger.trace("No match for \"{}\"", (Object)lookupPath);
        }
        return null;
    }
}

