/*
 * Decompiled with CFR 0.152.
 */
package infra.web.resource;

import infra.core.io.Resource;
import infra.lang.Assert;
import infra.lang.Nullable;
import infra.util.StringUtils;
import infra.web.RequestContext;
import infra.web.resource.ResourceTransformer;
import infra.web.resource.ResourceTransformerChain;
import infra.web.resource.ResourceUrlProvider;
import java.util.Collections;

public abstract class ResourceTransformerSupport
implements ResourceTransformer {
    @Nullable
    private ResourceUrlProvider resourceUrlProvider;

    public void setResourceUrlProvider(@Nullable ResourceUrlProvider resourceUrlProvider) {
        this.resourceUrlProvider = resourceUrlProvider;
    }

    @Nullable
    public ResourceUrlProvider getResourceUrlProvider() {
        return this.resourceUrlProvider;
    }

    @Nullable
    protected String resolveUrlPath(String resourcePath, RequestContext request, Resource resource, ResourceTransformerChain transformerChain) {
        if (resourcePath.startsWith("/")) {
            ResourceUrlProvider urlProvider = this.getResourceUrlProvider();
            return urlProvider != null ? urlProvider.getForRequestUrl(request, resourcePath) : null;
        }
        return transformerChain.getResolvingChain().resolveUrlPath(resourcePath, Collections.singletonList(resource));
    }

    protected String toAbsolutePath(String path, RequestContext request) {
        String absolutePath = path;
        if (!path.startsWith("/")) {
            ResourceUrlProvider urlProvider = this.getResourceUrlProvider();
            Assert.state((urlProvider != null ? 1 : 0) != 0, (String)"No ResourceUrlProvider");
            String requestPath = request.getRequestURI();
            absolutePath = StringUtils.applyRelativePath((String)requestPath, (String)path);
        }
        return StringUtils.cleanPath((String)absolutePath);
    }
}

