/*
 * Decompiled with CFR 0.152.
 */
package infra.web.resource;

import infra.beans.factory.InitializingBean;
import infra.context.ApplicationContext;
import infra.context.expression.EmbeddedValueResolverAware;
import infra.core.StringValueResolver;
import infra.core.io.Resource;
import infra.core.io.UrlResource;
import infra.http.HttpHeaders;
import infra.http.HttpMethod;
import infra.http.HttpRange;
import infra.http.HttpStatus;
import infra.http.MediaType;
import infra.http.MediaTypeFactory;
import infra.http.converter.ResourceHttpMessageConverter;
import infra.http.converter.ResourceRegionHttpMessageConverter;
import infra.http.server.ServerHttpResponse;
import infra.lang.Assert;
import infra.lang.Nullable;
import infra.logging.Logger;
import infra.logging.LoggerFactory;
import infra.util.CollectionUtils;
import infra.util.ObjectUtils;
import infra.util.StringUtils;
import infra.web.HandlerMatchingMetadata;
import infra.web.HttpRequestHandler;
import infra.web.NotFoundHandler;
import infra.web.RequestContext;
import infra.web.WebContentGenerator;
import infra.web.accept.ContentNegotiationManager;
import infra.web.cors.CorsConfiguration;
import infra.web.cors.CorsConfigurationSource;
import infra.web.handler.SimpleNotFoundHandler;
import infra.web.resource.DefaultResourceResolvingChain;
import infra.web.resource.DefaultResourceTransformerChain;
import infra.web.resource.HttpResource;
import infra.web.resource.PathResourceResolver;
import infra.web.resource.ResourceHandlerUtils;
import infra.web.resource.ResourceResolver;
import infra.web.resource.ResourceResolvingChain;
import infra.web.resource.ResourceTransformer;
import infra.web.resource.ResourceTransformerChain;
import java.io.IOException;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;

public class ResourceHttpRequestHandler
extends WebContentGenerator
implements HttpRequestHandler,
EmbeddedValueResolverAware,
InitializingBean,
CorsConfigurationSource {
    private static final Logger log = LoggerFactory.getLogger(ResourceHttpRequestHandler.class);
    private static final String URL_RESOURCE_CHARSET_PREFIX = "[charset=";
    private final ArrayList<String> locationValues = new ArrayList(4);
    private final ArrayList<Resource> locationResources = new ArrayList(4);
    private final ArrayList<Resource> locationsToUse = new ArrayList(4);
    private final HashMap<Resource, Charset> locationCharsets = new HashMap(4);
    private final ArrayList<ResourceResolver> resourceResolvers = new ArrayList(4);
    private final ArrayList<ResourceTransformer> resourceTransformers = new ArrayList(4);
    @Nullable
    private ResourceResolvingChain resolvingChain;
    @Nullable
    private ResourceTransformerChain transformerChain;
    @Nullable
    private ResourceHttpMessageConverter resourceHttpMessageConverter;
    @Nullable
    private ResourceRegionHttpMessageConverter resourceRegionHttpMessageConverter;
    @Nullable
    private ContentNegotiationManager contentNegotiationManager;
    private final Map<String, MediaType> mediaTypes = new HashMap<String, MediaType>(4);
    @Nullable
    private CorsConfiguration corsConfiguration;
    @Nullable
    private Function<Resource, String> etagGenerator;
    private boolean useLastModified = true;
    private boolean optimizeLocations = false;
    @Nullable
    private StringValueResolver embeddedValueResolver;
    private NotFoundHandler notFoundHandler = SimpleNotFoundHandler.sharedInstance;

    public ResourceHttpRequestHandler() {
        super(HttpMethod.GET.name(), HttpMethod.HEAD.name());
    }

    public void setLocationValues(List<String> locations) {
        Assert.notNull(locations, (String)"Locations list is required");
        this.locationValues.clear();
        this.locationValues.addAll(locations);
    }

    public void setLocations(List<Resource> locations) {
        Assert.notNull(locations, (String)"Locations list is required");
        this.locationResources.clear();
        for (Resource location : locations) {
            ResourceHandlerUtils.assertResourceLocation(location);
            this.locationResources.add(location);
        }
    }

    public List<Resource> getLocations() {
        if (this.locationsToUse.isEmpty()) {
            return this.locationResources;
        }
        return this.locationsToUse;
    }

    public void setResourceResolvers(@Nullable List<ResourceResolver> resourceResolvers) {
        this.resourceResolvers.clear();
        if (resourceResolvers != null) {
            this.resourceResolvers.addAll(resourceResolvers);
        }
    }

    public List<ResourceResolver> getResourceResolvers() {
        return this.resourceResolvers;
    }

    public void setResourceTransformers(@Nullable List<ResourceTransformer> resourceTransformers) {
        this.resourceTransformers.clear();
        if (resourceTransformers != null) {
            this.resourceTransformers.addAll(resourceTransformers);
        }
    }

    public List<ResourceTransformer> getResourceTransformers() {
        return this.resourceTransformers;
    }

    public void setResourceHttpMessageConverter(@Nullable ResourceHttpMessageConverter messageConverter) {
        this.resourceHttpMessageConverter = messageConverter;
    }

    @Nullable
    public ResourceHttpMessageConverter getResourceHttpMessageConverter() {
        return this.resourceHttpMessageConverter;
    }

    public void setResourceRegionHttpMessageConverter(@Nullable ResourceRegionHttpMessageConverter messageConverter) {
        this.resourceRegionHttpMessageConverter = messageConverter;
    }

    @Nullable
    public ResourceRegionHttpMessageConverter getResourceRegionHttpMessageConverter() {
        return this.resourceRegionHttpMessageConverter;
    }

    public void setContentNegotiationManager(@Nullable ContentNegotiationManager contentNegotiationManager) {
        this.contentNegotiationManager = contentNegotiationManager;
    }

    @Nullable
    public ContentNegotiationManager getContentNegotiationManager() {
        return this.contentNegotiationManager;
    }

    public void setMediaTypes(Map<String, MediaType> mediaTypes) {
        for (Map.Entry<String, MediaType> entry : mediaTypes.entrySet()) {
            this.mediaTypes.put(entry.getKey().toLowerCase(Locale.ROOT), entry.getValue());
        }
    }

    public Map<String, MediaType> getMediaTypes() {
        return this.mediaTypes;
    }

    public void setCorsConfiguration(@Nullable CorsConfiguration corsConfiguration) {
        this.corsConfiguration = corsConfiguration;
    }

    @Override
    @Nullable
    public CorsConfiguration getCorsConfiguration(RequestContext request) {
        return this.corsConfiguration;
    }

    public void setUseLastModified(boolean useLastModified) {
        this.useLastModified = useLastModified;
    }

    public boolean isUseLastModified() {
        return this.useLastModified;
    }

    public void setEtagGenerator(@Nullable Function<Resource, String> etagGenerator) {
        this.etagGenerator = etagGenerator;
    }

    @Nullable
    public Function<Resource, String> getEtagGenerator() {
        return this.etagGenerator;
    }

    public void setOptimizeLocations(boolean optimizeLocations) {
        this.optimizeLocations = optimizeLocations;
    }

    public boolean isOptimizeLocations() {
        return this.optimizeLocations;
    }

    public void setEmbeddedValueResolver(@Nullable StringValueResolver resolver) {
        this.embeddedValueResolver = resolver;
    }

    public void setNotFoundHandler(@Nullable NotFoundHandler notFoundHandler) {
        this.notFoundHandler = notFoundHandler == null ? SimpleNotFoundHandler.sharedInstance : notFoundHandler;
    }

    public void afterPropertiesSet() throws Exception {
        ContentNegotiationManager manager;
        this.resolveResourceLocations();
        if (this.resourceResolvers.isEmpty()) {
            this.resourceResolvers.add(new PathResourceResolver());
        }
        this.initAllowedLocations();
        this.resolvingChain = new DefaultResourceResolvingChain(this.resourceResolvers);
        this.transformerChain = new DefaultResourceTransformerChain(this.resolvingChain, this.resourceTransformers);
        if (this.resourceHttpMessageConverter == null) {
            this.resourceHttpMessageConverter = new ResourceHttpMessageConverter();
        }
        if (this.resourceRegionHttpMessageConverter == null) {
            this.resourceRegionHttpMessageConverter = new ResourceRegionHttpMessageConverter();
        }
        if ((manager = this.getContentNegotiationManager()) != null) {
            this.setMediaTypes(manager.getMediaTypeMappings());
        }
    }

    private void resolveResourceLocations() {
        ArrayList result = new ArrayList();
        if (!this.locationValues.isEmpty()) {
            ApplicationContext applicationContext = this.obtainApplicationContext();
            for (String location : this.locationValues) {
                if (this.embeddedValueResolver != null) {
                    String resolvedLocation = this.embeddedValueResolver.resolveStringValue(location);
                    if (resolvedLocation == null) {
                        throw new IllegalArgumentException("Location resolved to null: " + location);
                    }
                    location = resolvedLocation;
                }
                Charset charset = null;
                if ((location = location.trim()).startsWith(URL_RESOURCE_CHARSET_PREFIX)) {
                    int endIndex = location.indexOf(93, URL_RESOURCE_CHARSET_PREFIX.length());
                    if (endIndex == -1) {
                        throw new IllegalArgumentException("Invalid charset syntax in location: " + location);
                    }
                    String value = location.substring(URL_RESOURCE_CHARSET_PREFIX.length(), endIndex);
                    charset = Charset.forName(value);
                    location = location.substring(endIndex + 1);
                }
                Resource resource = applicationContext.getResource(location);
                if (location.equals("/")) {
                    throw new IllegalStateException("The String-based location \"/\" should be relative to the web application root but resolved to a Resource of type: %s. If this is intentional, please pass it as a pre-configured Resource via setLocations.".formatted(resource.getClass()));
                }
                result.add(resource);
                if (charset == null) continue;
                if (!(resource instanceof UrlResource)) {
                    throw new IllegalArgumentException("Unexpected charset for non-UrlResource: " + resource);
                }
                this.locationCharsets.put(resource, charset);
            }
        }
        result.addAll(this.locationResources);
        if (this.isOptimizeLocations()) {
            result = result.stream().filter(Resource::exists).collect(Collectors.toCollection(ArrayList::new));
        }
        this.locationsToUse.clear();
        this.locationsToUse.addAll(result);
    }

    protected void initAllowedLocations() {
        if (CollectionUtils.isEmpty(this.getLocations())) {
            return;
        }
        List<ResourceResolver> resourceResolvers = this.getResourceResolvers();
        for (int i = resourceResolvers.size() - 1; i >= 0; --i) {
            ResourceResolver resourceResolver = resourceResolvers.get(i);
            if (!(resourceResolver instanceof PathResourceResolver)) continue;
            PathResourceResolver pathResolver = (PathResourceResolver)resourceResolver;
            if (ObjectUtils.isEmpty((Object[])pathResolver.getAllowedLocations())) {
                pathResolver.setAllowedLocations(this.getLocations().toArray(Resource.EMPTY_ARRAY));
            }
            pathResolver.setLocationCharsets(this.locationCharsets);
            break;
        }
    }

    @Override
    public Object handleRequest(RequestContext request) throws Throwable {
        Resource resource = this.getResource(request);
        if (resource == null) {
            return this.notFoundHandler.handleNotFound(request);
        }
        if (HttpMethod.OPTIONS == request.getMethod()) {
            request.setHeader("Allow", this.getAllowHeader());
            return NONE_RETURN_VALUE;
        }
        this.checkRequest(request);
        String eTag = this.getETag(resource);
        if (request.checkNotModified(eTag, this.isUseLastModified() ? resource.lastModified() : -1L)) {
            log.trace("Resource not modified");
            return NONE_RETURN_VALUE;
        }
        this.prepareResponse(request);
        MediaType mediaType = this.getMediaType(request, resource);
        this.setHeaders(request, resource, mediaType);
        ServerHttpResponse outputMessage = request.asHttpOutputMessage();
        if (request.requestHeaders().get("Range") == null) {
            ResourceHttpMessageConverter converter = this.resourceHttpMessageConverter;
            Assert.state((converter != null ? 1 : 0) != 0, (String)"Not initialized");
            if (HttpMethod.HEAD == request.getMethod()) {
                converter.addDefaultHeaders(request.responseHeaders(), resource, mediaType);
            } else {
                converter.write(resource, mediaType, outputMessage);
            }
        } else {
            ResourceRegionHttpMessageConverter converter = this.resourceRegionHttpMessageConverter;
            Assert.state((converter != null ? 1 : 0) != 0, (String)"Not initialized");
            try {
                List<HttpRange> httpRanges = request.getHeaders().getRange();
                request.setStatus(HttpStatus.PARTIAL_CONTENT);
                converter.write(HttpRange.toResourceRegions(httpRanges, resource), mediaType, outputMessage);
            }
            catch (IllegalArgumentException ex) {
                request.setHeader("Content-Range", "bytes */" + resource.contentLength());
                request.sendError(HttpStatus.REQUESTED_RANGE_NOT_SATISFIABLE);
            }
        }
        return NONE_RETURN_VALUE;
    }

    @Nullable
    private String getETag(Resource resource) {
        Function<Resource, String> etagGenerator = this.getEtagGenerator();
        if (etagGenerator != null) {
            return etagGenerator.apply(resource);
        }
        return null;
    }

    @Nullable
    protected Resource getResource(RequestContext request) throws IOException {
        HandlerMatchingMetadata matchingMetadata = request.getMatchingMetadata();
        String path = matchingMetadata == null ? request.getRequestPath().value() : matchingMetadata.getPathWithinMapping().value();
        if (ResourceHandlerUtils.shouldIgnoreInputPath(path = this.processPath(path)) || this.isInvalidPath(path)) {
            return null;
        }
        ResourceResolvingChain resolvingChain = this.resolvingChain;
        ResourceTransformerChain transformerChain = this.transformerChain;
        Assert.state((resolvingChain != null ? 1 : 0) != 0, (String)"ResourceResolvingChain not initialized.");
        Assert.state((transformerChain != null ? 1 : 0) != 0, (String)"ResourceTransformerChain not initialized.");
        Resource resource = resolvingChain.resolveResource(request, path, this.getLocations());
        if (resource != null) {
            resource = transformerChain.transform(request, resource);
        }
        return resource;
    }

    protected String processPath(String path) {
        return ResourceHandlerUtils.normalizeInputPath(path);
    }

    protected boolean isInvalidPath(String path) {
        return false;
    }

    @Nullable
    protected MediaType getMediaType(RequestContext request, Resource resource) {
        List<MediaType> mediaTypes;
        MediaType result = null;
        MediaType mediaType = null;
        String filename = resource.getName();
        String ext = StringUtils.getFilenameExtension((String)filename);
        if (ext != null) {
            mediaType = this.mediaTypes.get(ext.toLowerCase(Locale.ROOT));
        }
        if (mediaType == null && CollectionUtils.isNotEmpty(mediaTypes = MediaTypeFactory.getMediaTypes(filename))) {
            mediaType = mediaTypes.get(0);
        }
        if (mediaType != null) {
            result = mediaType;
        }
        return result;
    }

    protected void setHeaders(RequestContext response, Resource resource, @Nullable MediaType mediaType) throws IOException {
        if (mediaType != null) {
            response.setContentType(mediaType.toString());
        }
        HttpHeaders responseHeaders = response.responseHeaders();
        if (resource instanceof HttpResource) {
            HttpResource httpResource = (HttpResource)resource;
            HttpHeaders resourceHeaders = httpResource.getResponseHeaders();
            for (Map.Entry entry : resourceHeaders.entrySet()) {
                boolean first = true;
                String headerName = (String)entry.getKey();
                List headerValues = (List)entry.getValue();
                for (String headerValue : headerValues) {
                    if (first) {
                        responseHeaders.setOrRemove(headerName, headerValue);
                    } else {
                        responseHeaders.add(headerName, headerValue);
                    }
                    first = false;
                }
            }
        }
        responseHeaders.setOrRemove("Accept-Ranges", "bytes");
    }

    public String toString() {
        return "ResourceHttpRequestHandler " + this.locationToString(this.getLocations());
    }

    private String locationToString(List<Resource> locations) {
        return locations.toString().replaceAll("class path resource", "classpath").replaceAll("MockContext resource", "MockContext");
    }
}

