/*
 * Decompiled with CFR 0.152.
 */
package infra.web.resource;

import infra.core.io.Resource;
import infra.core.io.UrlResource;
import infra.lang.Nullable;
import infra.util.LogFormatUtils;
import infra.util.StringUtils;
import infra.web.RequestContext;
import infra.web.resource.AbstractResourceResolver;
import infra.web.resource.ResourceHandlerUtils;
import infra.web.resource.ResourceResolvingChain;
import infra.web.util.UriUtils;
import java.io.IOException;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.StringTokenizer;

public class PathResourceResolver
extends AbstractResourceResolver {
    @Nullable
    private Resource[] allowedLocations;
    private boolean urlDecode = false;
    private final HashMap<Resource, Charset> locationCharsets = new HashMap(4);

    public void setAllowedLocations(Resource ... locations) {
        this.allowedLocations = locations;
    }

    @Nullable
    public Resource[] getAllowedLocations() {
        return this.allowedLocations;
    }

    public void setLocationCharsets(Map<Resource, Charset> locationCharsets) {
        this.locationCharsets.clear();
        this.locationCharsets.putAll(locationCharsets);
    }

    public void setUrlDecode(boolean urlDecode) {
        this.urlDecode = urlDecode;
    }

    public boolean isUrlDecode() {
        return this.urlDecode;
    }

    public Map<Resource, Charset> getLocationCharsets() {
        return Collections.unmodifiableMap(this.locationCharsets);
    }

    @Override
    protected Resource resolveResourceInternal(@Nullable RequestContext request, String requestPath, List<? extends Resource> locations, ResourceResolvingChain chain) {
        return this.getResource(requestPath, request, locations);
    }

    @Override
    protected String resolveUrlPathInternal(String resourcePath, List<? extends Resource> locations, ResourceResolvingChain chain) {
        return StringUtils.hasText((String)resourcePath) && this.getResource(resourcePath, null, locations) != null ? resourcePath : null;
    }

    @Nullable
    private Resource getResource(String resourcePath, @Nullable RequestContext request, List<? extends Resource> locations) {
        for (Resource resource : locations) {
            try {
                String pathToUse = this.encodeOrDecodeIfNecessary(resourcePath, request, resource);
                Resource resource2 = this.getResource(pathToUse, resource);
                if (resource2 == null) continue;
                return resource2;
            }
            catch (IOException ex) {
                if (!this.logger.isDebugEnabled()) continue;
                String error = "Skip location [%s] due to error".formatted(resource);
                if (this.logger.isTraceEnabled()) {
                    this.logger.trace(error, (Throwable)ex);
                    continue;
                }
                this.logger.debug("{}: {}", (Object)error, (Object)ex.getMessage());
            }
        }
        return null;
    }

    @Nullable
    protected Resource getResource(String resourcePath, Resource location) throws IOException {
        Resource resource = location.createRelative(resourcePath);
        if (resource.isReadable()) {
            if (this.checkResource(resource, location)) {
                return resource;
            }
            if (this.logger.isWarnEnabled()) {
                Resource[] allowed = this.getAllowedLocations();
                this.logger.warn(LogFormatUtils.formatValue((Object)"Resource path \"%s\" was successfully resolved but resource \"%s\" is neither under the current location \"%s\" nor under any of the allowed locations %s".formatted(resourcePath, resource.getURL(), location.getURL(), allowed != null ? Arrays.asList(allowed) : "[]"), (int)-1, (boolean)true));
            }
        }
        return null;
    }

    protected boolean checkResource(Resource resource, Resource location) throws IOException {
        if (ResourceHandlerUtils.isResourceUnderLocation(location, resource)) {
            return true;
        }
        Resource[] allowedLocations = this.getAllowedLocations();
        if (allowedLocations != null) {
            for (Resource current : allowedLocations) {
                if (!ResourceHandlerUtils.isResourceUnderLocation(current, resource)) continue;
                return true;
            }
        }
        return false;
    }

    private String encodeOrDecodeIfNecessary(String path, @Nullable RequestContext request, Resource location) {
        if (request != null) {
            if (this.shouldDecodeRelativePath(location)) {
                try {
                    return UriUtils.decode(path, StandardCharsets.UTF_8);
                }
                catch (IllegalArgumentException e) {
                    return path;
                }
            }
            if (this.shouldEncodeRelativePath(location)) {
                Charset charset = this.locationCharsets.getOrDefault(location, StandardCharsets.UTF_8);
                StringBuilder sb = new StringBuilder();
                StringTokenizer tokenizer = new StringTokenizer(path, "/");
                while (tokenizer.hasMoreTokens()) {
                    String value = UriUtils.encode(tokenizer.nextToken(), charset);
                    sb.append(value);
                    sb.append('/');
                }
                if (!path.endsWith("/")) {
                    sb.setLength(sb.length() - 1);
                }
                return sb.toString();
            }
        }
        return path;
    }

    private boolean shouldDecodeRelativePath(Resource location) {
        return !(location instanceof UrlResource);
    }

    private boolean shouldEncodeRelativePath(Resource location) {
        return this.urlDecode && location instanceof UrlResource;
    }
}

