/*
 * Decompiled with CFR 0.152.
 */
package infra.web.resource;

import infra.core.io.Resource;
import infra.lang.Nullable;
import infra.web.RequestContext;
import infra.web.resource.AbstractResourceResolver;
import infra.web.resource.ResourceResolvingChain;
import java.util.List;
import org.webjars.WebJarVersionLocator;

public class LiteWebJarsResourceResolver
extends AbstractResourceResolver {
    private static final int WEBJARS_LOCATION_LENGTH = "META-INF/resources/webjars".length() + 1;
    private final WebJarVersionLocator webJarVersionLocator;

    public LiteWebJarsResourceResolver() {
        this.webJarVersionLocator = new WebJarVersionLocator();
    }

    public LiteWebJarsResourceResolver(WebJarVersionLocator webJarVersionLocator) {
        this.webJarVersionLocator = webJarVersionLocator;
    }

    @Override
    @Nullable
    protected Resource resolveResourceInternal(@Nullable RequestContext request, String requestPath, List<? extends Resource> locations, ResourceResolvingChain chain) {
        String webJarResourcePath;
        Resource resolved = chain.resolveResource(request, requestPath, locations);
        if (resolved == null && (webJarResourcePath = this.findWebJarResourcePath(requestPath)) != null) {
            return chain.resolveResource(request, webJarResourcePath, locations);
        }
        return resolved;
    }

    @Override
    @Nullable
    protected String resolveUrlPathInternal(String resourceUrlPath, List<? extends Resource> locations, ResourceResolvingChain chain) {
        String webJarResourcePath;
        String path = chain.resolveUrlPath(resourceUrlPath, locations);
        if (path == null && (webJarResourcePath = this.findWebJarResourcePath(resourceUrlPath)) != null) {
            return chain.resolveUrlPath(webJarResourcePath, locations);
        }
        return path;
    }

    @Nullable
    protected String findWebJarResourcePath(String path) {
        String partialPath;
        int startOffset;
        String webjar;
        String webJarPath;
        int endOffset = path.indexOf(47, 1);
        if (endOffset != -1 && (webJarPath = this.webJarVersionLocator.fullPath(webjar = path.substring(startOffset = path.startsWith("/") ? 1 : 0, endOffset), partialPath = path.substring(endOffset + 1))) != null) {
            return webJarPath.substring(WEBJARS_LOCATION_LENGTH);
        }
        return null;
    }
}

