/*
 * Decompiled with CFR 0.152.
 */
package infra.web.resource;

import infra.core.io.AbstractResource;
import infra.core.io.Resource;
import infra.core.io.ResourceFilter;
import infra.http.HttpHeaders;
import infra.lang.Assert;
import infra.lang.Nullable;
import infra.web.RequestContext;
import infra.web.resource.AbstractResourceResolver;
import infra.web.resource.HttpResource;
import infra.web.resource.ResourceResolvingChain;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.net.URI;
import java.net.URL;
import java.nio.channels.ReadableByteChannel;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;

public class EncodedResourceResolver
extends AbstractResourceResolver {
    public static final List<String> DEFAULT_CODINGS = Arrays.asList("br", "gzip");
    private final ArrayList<String> contentCodings = new ArrayList<String>(DEFAULT_CODINGS);
    private final LinkedHashMap<String, String> extensions = new LinkedHashMap();

    public EncodedResourceResolver() {
        this.extensions.put("gzip", ".gz");
        this.extensions.put("br", ".br");
    }

    public void setContentCodings(List<String> codings) {
        Assert.notEmpty(codings, (String)"At least one content coding expected");
        this.contentCodings.clear();
        this.contentCodings.addAll(codings);
    }

    public List<String> getContentCodings() {
        return this.contentCodings;
    }

    public void setExtensions(Map<String, String> extensions) {
        for (Map.Entry<String, String> entry : extensions.entrySet()) {
            this.registerExtension(entry.getKey(), entry.getValue());
        }
    }

    public Map<String, String> getExtensions() {
        return this.extensions;
    }

    public void registerExtension(String coding, String extension) {
        this.extensions.put(coding, (String)(extension.startsWith(".") ? extension : "." + extension));
    }

    @Override
    protected Resource resolveResourceInternal(@Nullable RequestContext request, String requestPath, List<? extends Resource> locations, ResourceResolvingChain chain) {
        Resource resource = chain.resolveResource(request, requestPath, locations);
        if (resource == null || request == null) {
            return resource;
        }
        String acceptEncoding = this.getAcceptEncoding(request);
        if (acceptEncoding == null) {
            return resource;
        }
        for (String coding : this.contentCodings) {
            if (!acceptEncoding.contains(coding)) continue;
            try {
                String extension = this.getExtension(coding);
                EncodedResource encoded = new EncodedResource(resource, coding, extension);
                if (!encoded.exists()) continue;
                return encoded;
            }
            catch (IOException ex) {
                if (!this.logger.isTraceEnabled()) continue;
                this.logger.trace("No {} resource for [{}]", new Object[]{coding, resource.getName(), ex});
            }
        }
        return resource;
    }

    @Nullable
    private String getAcceptEncoding(RequestContext request) {
        String header = request.getHeaders().getFirst("Accept-Encoding");
        return header != null ? header.toLowerCase(Locale.ROOT) : null;
    }

    private String getExtension(String coding) {
        String extension = this.extensions.get(coding);
        if (extension == null) {
            throw new IllegalStateException("No file extension associated with content coding " + coding);
        }
        return extension;
    }

    @Override
    protected String resolveUrlPathInternal(String resourceUrlPath, List<? extends Resource> locations, ResourceResolvingChain chain) {
        return chain.resolveUrlPath(resourceUrlPath, locations);
    }

    static final class EncodedResource
    extends AbstractResource
    implements HttpResource {
        private final String coding;
        private final Resource encoded;
        private final Resource original;

        EncodedResource(Resource original, String coding, String extension) throws IOException {
            this.original = original;
            this.coding = coding;
            this.encoded = original.createRelative(original.getName() + extension);
        }

        public InputStream getInputStream() throws IOException {
            return this.encoded.getInputStream();
        }

        public boolean exists() {
            return this.encoded.exists();
        }

        public boolean isReadable() {
            return this.encoded.isReadable();
        }

        public boolean isOpen() {
            return this.encoded.isOpen();
        }

        public URL getURL() throws IOException {
            return this.encoded.getURL();
        }

        public URI getURI() throws IOException {
            return this.encoded.getURI();
        }

        public File getFile() throws IOException {
            return this.encoded.getFile();
        }

        public long contentLength() throws IOException {
            return this.encoded.contentLength();
        }

        public long lastModified() throws IOException {
            return this.encoded.lastModified();
        }

        public Resource createRelative(String relativePath) throws IOException {
            return this.encoded.createRelative(relativePath);
        }

        @Nullable
        public String getName() {
            return this.original.getName();
        }

        public ReadableByteChannel readableChannel() throws IOException {
            return this.encoded.readableChannel();
        }

        public Reader getReader() throws IOException {
            return this.original.getReader();
        }

        public Reader getReader(String encoding) throws IOException {
            return this.original.getReader(encoding);
        }

        public boolean isFile() {
            return this.original.isFile();
        }

        public boolean isDirectory() throws IOException {
            return this.original.isDirectory();
        }

        public String[] list() throws IOException {
            return this.original.list();
        }

        public Resource[] list(@Nullable ResourceFilter filter) throws IOException {
            return this.original.list(filter);
        }

        public byte[] getContentAsByteArray() throws IOException {
            return this.encoded.getContentAsByteArray();
        }

        public String getContentAsString(Charset charset) throws IOException {
            return this.encoded.getContentAsString(charset);
        }

        @Override
        public HttpHeaders getResponseHeaders() {
            HttpHeaders headers;
            Resource resource = this.original;
            if (resource instanceof HttpResource) {
                HttpResource o = (HttpResource)resource;
                headers = o.getResponseHeaders();
            } else {
                headers = HttpHeaders.forWritable();
            }
            headers.add("Content-Encoding", this.coding);
            headers.add("Vary", "Accept-Encoding");
            return headers;
        }
    }
}

