/*
 * Decompiled with CFR 0.152.
 */
package infra.web.resource;

import infra.core.io.Resource;
import infra.lang.Assert;
import infra.lang.Nullable;
import infra.web.RequestContext;
import infra.web.resource.ResourceResolvingChain;
import infra.web.resource.ResourceTransformer;
import infra.web.resource.ResourceTransformerChain;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.ListIterator;

class DefaultResourceTransformerChain
implements ResourceTransformerChain {
    private final ResourceResolvingChain resolverChain;
    @Nullable
    private final ResourceTransformer transformer;
    @Nullable
    private final ResourceTransformerChain nextChain;

    public DefaultResourceTransformerChain(ResourceResolvingChain resolverChain, @Nullable List<ResourceTransformer> transformers) {
        Assert.notNull((Object)resolverChain, (String)"ResourceResolverChain is required");
        this.resolverChain = resolverChain;
        transformers = transformers != null ? transformers : Collections.emptyList();
        DefaultResourceTransformerChain chain = this.initTransformerChain(resolverChain, new ArrayList<ResourceTransformer>(transformers));
        this.transformer = chain.transformer;
        this.nextChain = chain.nextChain;
    }

    private DefaultResourceTransformerChain initTransformerChain(ResourceResolvingChain resolverChain, ArrayList<ResourceTransformer> transformers) {
        DefaultResourceTransformerChain chain = new DefaultResourceTransformerChain(resolverChain, null, null);
        ListIterator<ResourceTransformer> it = transformers.listIterator(transformers.size());
        while (it.hasPrevious()) {
            chain = new DefaultResourceTransformerChain(resolverChain, it.previous(), chain);
        }
        return chain;
    }

    public DefaultResourceTransformerChain(ResourceResolvingChain resolverChain, @Nullable ResourceTransformer transformer, @Nullable ResourceTransformerChain chain) {
        Assert.isTrue((transformer == null && chain == null || transformer != null && chain != null ? 1 : 0) != 0, (String)"Both transformer and transformer chain must be null, or neither is");
        this.resolverChain = resolverChain;
        this.transformer = transformer;
        this.nextChain = chain;
    }

    @Override
    public ResourceResolvingChain getResolvingChain() {
        return this.resolverChain;
    }

    @Override
    public Resource transform(RequestContext request, Resource resource) throws IOException {
        return this.transformer != null && this.nextChain != null ? this.transformer.transform(request, resource, this.nextChain) : resource;
    }
}

