/*
 * Decompiled with CFR 0.152.
 */
package infra.web.resource;

import infra.core.io.Resource;
import infra.lang.Assert;
import infra.lang.Nullable;
import infra.web.RequestContext;
import infra.web.resource.ResourceResolver;
import infra.web.resource.ResourceResolvingChain;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.ListIterator;

class DefaultResourceResolvingChain
implements ResourceResolvingChain {
    @Nullable
    private final ResourceResolver resolver;
    @Nullable
    private final ResourceResolvingChain nextChain;

    public DefaultResourceResolvingChain(@Nullable List<? extends ResourceResolver> resolvers) {
        if (resolvers == null) {
            resolvers = Collections.emptyList();
        }
        DefaultResourceResolvingChain chain = DefaultResourceResolvingChain.initChain(new ArrayList<ResourceResolver>(resolvers));
        this.resolver = chain.resolver;
        this.nextChain = chain.nextChain;
    }

    private static DefaultResourceResolvingChain initChain(ArrayList<? extends ResourceResolver> resolvers) {
        DefaultResourceResolvingChain chain = new DefaultResourceResolvingChain(null, null);
        ListIterator<? extends ResourceResolver> it = resolvers.listIterator(resolvers.size());
        while (it.hasPrevious()) {
            chain = new DefaultResourceResolvingChain(it.previous(), chain);
        }
        return chain;
    }

    private DefaultResourceResolvingChain(@Nullable ResourceResolver resolver, @Nullable ResourceResolvingChain chain) {
        Assert.isTrue((resolver == null && chain == null || resolver != null && chain != null ? 1 : 0) != 0, (String)"Both resolver and resolver chain must be null, or neither is");
        this.resolver = resolver;
        this.nextChain = chain;
    }

    @Override
    @Nullable
    public Resource resolveResource(@Nullable RequestContext request, String requestPath, List<? extends Resource> locations) {
        return this.resolver != null && this.nextChain != null ? this.resolver.resolveResource(request, requestPath, locations, this.nextChain) : null;
    }

    @Override
    @Nullable
    public String resolveUrlPath(String resourcePath, List<? extends Resource> locations) {
        return this.resolver != null && this.nextChain != null ? this.resolver.resolveUrlPath(resourcePath, locations, this.nextChain) : null;
    }
}

