/*
 * Decompiled with CFR 0.152.
 */
package infra.web.resource;

import infra.core.io.Resource;
import infra.util.DigestUtils;
import infra.util.FileCopyUtils;
import infra.web.resource.AbstractVersionStrategy;
import java.io.IOException;
import java.io.InputStream;

public class ContentVersionStrategy
extends AbstractVersionStrategy {
    public ContentVersionStrategy() {
        super(new AbstractVersionStrategy.FileNameVersionPathStrategy());
    }

    @Override
    public String getResourceVersion(Resource resource) {
        try {
            byte[] content = FileCopyUtils.copyToByteArray((InputStream)resource.getInputStream());
            return DigestUtils.md5DigestAsHex((byte[])content);
        }
        catch (IOException ex) {
            throw new IllegalStateException("Failed to calculate hash for " + resource, ex);
        }
    }
}

