/*
 * Decompiled with CFR 0.152.
 */
package infra.web.resource;

import infra.cache.Cache;
import infra.cache.CacheManager;
import infra.core.io.Resource;
import infra.lang.Assert;
import infra.logging.Logger;
import infra.logging.LoggerFactory;
import infra.web.RequestContext;
import infra.web.resource.ResourceTransformer;
import infra.web.resource.ResourceTransformerChain;
import java.io.IOException;

public class CachingResourceTransformer
implements ResourceTransformer {
    private static final Logger logger = LoggerFactory.getLogger(CachingResourceTransformer.class);
    private final Cache cache;

    public CachingResourceTransformer(Cache cache) {
        Assert.notNull((Object)cache, (String)"Cache is required");
        this.cache = cache;
    }

    public CachingResourceTransformer(CacheManager cacheManager, String cacheName) {
        Cache cache = cacheManager.getCache(cacheName);
        if (cache == null) {
            throw new IllegalArgumentException("Cache '%s' not found".formatted(cacheName));
        }
        this.cache = cache;
    }

    public Cache getCache() {
        return this.cache;
    }

    @Override
    public Resource transform(RequestContext request, Resource resource, ResourceTransformerChain transformerChain) throws IOException {
        Resource transformed = (Resource)this.cache.get((Object)resource, Resource.class);
        if (transformed != null) {
            logger.trace("Resource resolved from cache");
            return transformed;
        }
        transformed = transformerChain.transform(request, resource);
        this.cache.put((Object)resource, (Object)transformed);
        return transformed;
    }
}

