/*
 * Decompiled with CFR 0.152.
 */
package infra.web.resource;

import infra.cache.Cache;
import infra.cache.CacheManager;
import infra.core.io.Resource;
import infra.lang.Assert;
import infra.lang.Nullable;
import infra.util.StringUtils;
import infra.web.RequestContext;
import infra.web.resource.AbstractResourceResolver;
import infra.web.resource.EncodedResourceResolver;
import infra.web.resource.ResourceResolvingChain;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import java.util.stream.Collectors;

public class CachingResourceResolver
extends AbstractResourceResolver {
    public static final String RESOLVED_RESOURCE_CACHE_KEY_PREFIX = "resolvedResource:";
    public static final String RESOLVED_URL_PATH_CACHE_KEY_PREFIX = "resolvedUrlPath:";
    private final Cache cache;
    private final List<String> contentCodings = new ArrayList<String>(EncodedResourceResolver.DEFAULT_CODINGS);

    public CachingResourceResolver(Cache cache) {
        Assert.notNull((Object)cache, (String)"Cache is required");
        this.cache = cache;
    }

    public CachingResourceResolver(CacheManager cacheManager, String cacheName) {
        Cache cache = cacheManager.getCache(cacheName);
        if (cache == null) {
            throw new IllegalArgumentException("Cache '%s' not found".formatted(cacheName));
        }
        this.cache = cache;
    }

    public Cache getCache() {
        return this.cache;
    }

    public void setContentCodings(List<String> codings) {
        Assert.notEmpty(codings, (String)"At least one content coding expected");
        this.contentCodings.clear();
        this.contentCodings.addAll(codings);
    }

    public List<String> getContentCodings() {
        return Collections.unmodifiableList(this.contentCodings);
    }

    @Override
    protected Resource resolveResourceInternal(@Nullable RequestContext request, String requestPath, List<? extends Resource> locations, ResourceResolvingChain chain) {
        String key = this.computeKey(request, requestPath);
        Resource resource = (Resource)this.cache.get((Object)key, Resource.class);
        if (resource != null) {
            if (this.logger.isTraceEnabled()) {
                this.logger.trace("Resource resolved from cache");
            }
            return resource;
        }
        resource = chain.resolveResource(request, requestPath, locations);
        if (resource != null) {
            this.cache.put((Object)key, (Object)resource);
        }
        return resource;
    }

    protected String computeKey(@Nullable RequestContext request, String requestPath) {
        String codingKey;
        if (request != null && StringUtils.hasText((String)(codingKey = this.getContentCodingKey(request)))) {
            return RESOLVED_RESOURCE_CACHE_KEY_PREFIX + requestPath + "+encoding=" + codingKey;
        }
        return RESOLVED_RESOURCE_CACHE_KEY_PREFIX + requestPath;
    }

    @Nullable
    private String getContentCodingKey(RequestContext request) {
        String header = request.getHeaders().getFirst("Accept-Encoding");
        if (StringUtils.hasText((String)header)) {
            return Arrays.stream(StringUtils.tokenizeToStringArray((String)header, (String)",")).map(token -> {
                int index = token.indexOf(59);
                return (index >= 0 ? token.substring(0, index) : token).trim().toLowerCase(Locale.ROOT);
            }).filter(this.contentCodings::contains).sorted().collect(Collectors.joining(","));
        }
        return null;
    }

    @Override
    protected String resolveUrlPathInternal(String resourceUrlPath, List<? extends Resource> locations, ResourceResolvingChain chain) {
        String key = RESOLVED_URL_PATH_CACHE_KEY_PREFIX + resourceUrlPath;
        String resolvedUrlPath = (String)this.cache.get((Object)key, String.class);
        if (resolvedUrlPath != null) {
            if (this.logger.isTraceEnabled()) {
                this.logger.trace("Path resolved from cache");
            }
            return resolvedUrlPath;
        }
        resolvedUrlPath = chain.resolveUrlPath(resourceUrlPath, locations);
        if (resolvedUrlPath != null) {
            this.cache.put((Object)key, (Object)resolvedUrlPath);
        }
        return resolvedUrlPath;
    }
}

