/*
 * Decompiled with CFR 0.152.
 */
package infra.web.reactive.function;

import infra.core.NestedRuntimeException;
import infra.core.ResolvableType;
import infra.http.MediaType;
import infra.lang.Nullable;
import java.io.Serializable;
import java.util.Collections;
import java.util.List;

public class UnsupportedMediaTypeException
extends NestedRuntimeException {
    @Nullable
    private final MediaType contentType;
    private final List<MediaType> supportedMediaTypes;
    @Nullable
    private final ResolvableType bodyType;

    public UnsupportedMediaTypeException(@Nullable MediaType contentType, List<MediaType> supportedTypes, @Nullable ResolvableType bodyType) {
        super(UnsupportedMediaTypeException.initReason(contentType, bodyType));
        this.contentType = contentType;
        this.supportedMediaTypes = Collections.unmodifiableList(supportedTypes);
        this.bodyType = bodyType;
    }

    private static String initReason(@Nullable MediaType contentType, @Nullable ResolvableType bodyType) {
        return "Content type '" + (Serializable)(contentType != null ? contentType : "") + "' not supported" + (String)(bodyType != null ? " for bodyType=" + bodyType.toString() : "");
    }

    @Nullable
    public MediaType getContentType() {
        return this.contentType;
    }

    public List<MediaType> getSupportedMediaTypes() {
        return this.supportedMediaTypes;
    }

    @Nullable
    public ResolvableType getBodyType() {
        return this.bodyType;
    }
}

