/*
 * Decompiled with CFR 0.152.
 */
package infra.web.reactive.function;

import infra.core.ParameterizedTypeReference;
import infra.core.ReactiveAdapter;
import infra.core.ReactiveAdapterRegistry;
import infra.core.ResolvableType;
import infra.core.io.Resource;
import infra.core.io.buffer.DataBuffer;
import infra.core.io.buffer.DataBufferFactory;
import infra.core.io.buffer.DataBufferUtils;
import infra.http.HttpEntity;
import infra.http.MediaType;
import infra.http.ReactiveHttpOutputMessage;
import infra.http.client.MultipartBodyBuilder;
import infra.http.client.reactive.ClientHttpRequest;
import infra.http.codec.HttpMessageWriter;
import infra.http.codec.ServerSentEvent;
import infra.http.server.reactive.ServerHttpRequest;
import infra.http.server.reactive.ServerHttpResponse;
import infra.lang.Assert;
import infra.lang.Nullable;
import infra.util.LinkedMultiValueMap;
import infra.util.MultiValueMap;
import infra.web.reactive.function.BodyInserter;
import infra.web.reactive.function.UnsupportedMediaTypeException;
import java.io.OutputStream;
import java.lang.reflect.Type;
import java.util.List;
import java.util.concurrent.Executor;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import org.reactivestreams.Publisher;
import reactor.core.publisher.Mono;

public abstract class BodyInserters {
    private static final ResolvableType RESOURCE_TYPE = ResolvableType.forClass(Resource.class);
    private static final ResolvableType SSE_TYPE = ResolvableType.forClass(ServerSentEvent.class);
    private static final ResolvableType FORM_DATA_TYPE = ResolvableType.forClassWithGenerics(MultiValueMap.class, (Class[])new Class[]{String.class, String.class});
    private static final ResolvableType MULTIPART_DATA_TYPE = ResolvableType.forClassWithGenerics(MultiValueMap.class, (Class[])new Class[]{String.class, Object.class});
    private static final BodyInserter<Void, ReactiveHttpOutputMessage> EMPTY_INSERTER = (response, context) -> response.setComplete();
    private static final ReactiveAdapterRegistry registry = ReactiveAdapterRegistry.getSharedInstance();

    public static <T> BodyInserter<T, ReactiveHttpOutputMessage> empty() {
        return EMPTY_INSERTER;
    }

    public static <T> BodyInserter<T, ReactiveHttpOutputMessage> fromValue(T body) {
        Assert.notNull(body, (String)"'body' is required");
        Assert.isNull((Object)registry.getAdapter(body.getClass()), (String)"'body' should be an object, for reactive types use a variant specifying a publisher/producer and its related element type");
        return (message, context) -> BodyInserters.writeWithMessageWriters(message, context, Mono.just((Object)body), ResolvableType.forInstance((Object)body), null);
    }

    public static <T> BodyInserter<T, ReactiveHttpOutputMessage> fromProducer(T producer, Class<?> elementClass) {
        Assert.notNull(producer, (String)"'producer' is required");
        Assert.notNull(elementClass, (String)"'elementClass' is required");
        ReactiveAdapter adapter = registry.getAdapter(producer.getClass());
        Assert.notNull((Object)adapter, (String)"'producer' type is unknown to ReactiveAdapterRegistry");
        return (message, context) -> BodyInserters.writeWithMessageWriters(message, context, producer, ResolvableType.forClass((Class)elementClass), adapter);
    }

    public static <T> BodyInserter<T, ReactiveHttpOutputMessage> fromProducer(T producer, ParameterizedTypeReference<?> elementTypeRef) {
        Assert.notNull(producer, (String)"'producer' is required");
        Assert.notNull(elementTypeRef, (String)"'elementTypeRef' is required");
        ReactiveAdapter adapter = registry.getAdapter(producer.getClass());
        Assert.notNull((Object)adapter, (String)"'producer' type is unknown to ReactiveAdapterRegistry");
        return (message, context) -> BodyInserters.writeWithMessageWriters(message, context, producer, ResolvableType.forType((ParameterizedTypeReference)elementTypeRef), adapter);
    }

    public static <T, P extends Publisher<T>> BodyInserter<P, ReactiveHttpOutputMessage> fromPublisher(P publisher, Class<T> elementClass) {
        Assert.notNull(publisher, (String)"'publisher' is required");
        Assert.notNull(elementClass, (String)"'elementClass' is required");
        return (message, context) -> BodyInserters.writeWithMessageWriters(message, context, publisher, ResolvableType.forClass((Class)elementClass), null);
    }

    public static <T, P extends Publisher<T>> BodyInserter<P, ReactiveHttpOutputMessage> fromPublisher(P publisher, ParameterizedTypeReference<T> elementTypeRef) {
        Assert.notNull(publisher, (String)"'publisher' is required");
        Assert.notNull(elementTypeRef, (String)"'elementTypeRef' is required");
        return (message, context) -> BodyInserters.writeWithMessageWriters(message, context, publisher, ResolvableType.forType((Type)elementTypeRef.getType()), null);
    }

    public static <T extends Resource> BodyInserter<T, ReactiveHttpOutputMessage> fromResource(T resource) {
        Assert.notNull(resource, (String)"'resource' is required");
        return (outputMessage, context) -> {
            ResolvableType elementType = RESOURCE_TYPE;
            HttpMessageWriter writer = BodyInserters.findWriter(context, elementType, null);
            MediaType contentType = outputMessage.getHeaders().getContentType();
            return BodyInserters.write(Mono.just((Object)resource), elementType, contentType, outputMessage, context, writer);
        };
    }

    public static <T, S extends Publisher<ServerSentEvent<T>>> BodyInserter<S, ServerHttpResponse> fromServerSentEvents(S eventsPublisher) {
        Assert.notNull(eventsPublisher, (String)"'eventsPublisher' is required");
        return (serverResponse, context) -> {
            ResolvableType elementType = SSE_TYPE;
            MediaType mediaType = MediaType.TEXT_EVENT_STREAM;
            HttpMessageWriter writer = BodyInserters.findWriter(context, elementType, mediaType);
            return BodyInserters.write(eventsPublisher, elementType, mediaType, serverResponse, context, writer);
        };
    }

    public static FormInserter<String> fromFormData(MultiValueMap<String, String> formData) {
        return new DefaultFormInserter().with(formData);
    }

    public static FormInserter<String> fromFormData(String name, String value) {
        Assert.notNull((Object)name, (String)"'name' is required");
        Assert.notNull((Object)value, (String)"'value' is required");
        return new DefaultFormInserter().with(name, value);
    }

    public static MultipartInserter fromMultipartData(MultiValueMap<String, ?> multipartData) {
        Assert.notNull(multipartData, (String)"'multipartData' is required");
        return new DefaultMultipartInserter().withInternal(multipartData);
    }

    public static MultipartInserter fromMultipartData(String name, Object value) {
        Assert.notNull((Object)name, (String)"'name' is required");
        Assert.notNull((Object)value, (String)"'value' is required");
        return new DefaultMultipartInserter().with(name, value);
    }

    public static <T, P extends Publisher<T>> MultipartInserter fromMultipartAsyncData(String name, P publisher, Class<T> elementClass) {
        return new DefaultMultipartInserter().withPublisher(name, publisher, elementClass);
    }

    public static <T, P extends Publisher<T>> MultipartInserter fromMultipartAsyncData(String name, P publisher, ParameterizedTypeReference<T> typeReference) {
        return new DefaultMultipartInserter().withPublisher(name, publisher, typeReference);
    }

    public static <T extends Publisher<DataBuffer>> BodyInserter<T, ReactiveHttpOutputMessage> fromDataBuffers(T publisher) {
        Assert.notNull(publisher, (String)"'publisher' is required");
        return (outputMessage, context) -> outputMessage.writeWith((Publisher<? extends DataBuffer>)publisher);
    }

    public static <T extends Publisher<DataBuffer>> BodyInserter<T, ReactiveHttpOutputMessage> fromOutputStream(Consumer<OutputStream> outputStreamConsumer, Executor executor) {
        Assert.notNull(outputStreamConsumer, (String)"OutputStreamConsumer is required");
        Assert.notNull((Object)executor, (String)"Executor is required");
        return (outputMessage, context) -> outputMessage.writeWith((Publisher<? extends DataBuffer>)DataBufferUtils.outputStreamPublisher((Consumer)outputStreamConsumer, (DataBufferFactory)outputMessage.bufferFactory(), (Executor)executor));
    }

    public static <T extends Publisher<DataBuffer>> BodyInserter<T, ReactiveHttpOutputMessage> fromOutputStream(Consumer<OutputStream> outputStreamConsumer, Executor executor, int chunkSize) {
        Assert.notNull(outputStreamConsumer, (String)"OutputStreamConsumer is required");
        Assert.notNull((Object)executor, (String)"Executor is required");
        Assert.isTrue((chunkSize > 0 ? 1 : 0) != 0, (String)"Chunk size must be > 0");
        return (outputMessage, context) -> outputMessage.writeWith((Publisher<? extends DataBuffer>)DataBufferUtils.outputStreamPublisher((Consumer)outputStreamConsumer, (DataBufferFactory)outputMessage.bufferFactory(), (Executor)executor, (int)chunkSize));
    }

    private static <M extends ReactiveHttpOutputMessage> Mono<Void> writeWithMessageWriters(M outputMessage, BodyInserter.Context context, Object body, ResolvableType bodyType, @Nullable ReactiveAdapter adapter) {
        Publisher publisherBody;
        Object publisher = body instanceof Publisher ? (publisherBody = (Publisher)body) : (adapter != null ? adapter.toPublisher(body) : Mono.just((Object)body));
        MediaType mediaType = outputMessage.getHeaders().getContentType();
        for (HttpMessageWriter<?> messageWriter : context.messageWriters()) {
            if (!messageWriter.canWrite(bodyType, mediaType)) continue;
            return BodyInserters.write(publisher, bodyType, mediaType, outputMessage, context, BodyInserters.cast(messageWriter));
        }
        return Mono.error((Throwable)((Object)BodyInserters.unsupportedError(bodyType, context, mediaType)));
    }

    private static UnsupportedMediaTypeException unsupportedError(ResolvableType bodyType, BodyInserter.Context context, @Nullable MediaType mediaType) {
        List<MediaType> supportedMediaTypes = context.messageWriters().stream().flatMap(reader -> reader.getWritableMediaTypes(bodyType).stream()).collect(Collectors.toList());
        return new UnsupportedMediaTypeException(mediaType, supportedMediaTypes, bodyType);
    }

    private static <T> Mono<Void> write(Publisher<? extends T> input, ResolvableType type, @Nullable MediaType mediaType, ReactiveHttpOutputMessage message, BodyInserter.Context context, HttpMessageWriter<T> writer) {
        return context.serverRequest().map(request -> {
            ServerHttpResponse response = (ServerHttpResponse)message;
            return writer.write((Publisher)input, type, type, mediaType, (ServerHttpRequest)request, response, context.hints());
        }).orElseGet(() -> writer.write(input, type, mediaType, message, context.hints()));
    }

    private static <T> HttpMessageWriter<T> findWriter(BodyInserter.Context context, ResolvableType elementType, @Nullable MediaType mediaType) {
        for (HttpMessageWriter<?> messageWriter : context.messageWriters()) {
            if (!messageWriter.canWrite(elementType, mediaType)) continue;
            return BodyInserters.cast(messageWriter);
        }
        throw new IllegalStateException("No HttpMessageWriter for \"" + mediaType + "\" and \"" + elementType + "\"");
    }

    private static <T> HttpMessageWriter<T> cast(HttpMessageWriter<?> messageWriter) {
        return messageWriter;
    }

    private static class DefaultFormInserter
    implements FormInserter<String> {
        private final MultiValueMap<String, String> data = new LinkedMultiValueMap();

        private DefaultFormInserter() {
        }

        @Override
        public FormInserter<String> with(String key, @Nullable String value) {
            this.data.add((Object)key, (Object)value);
            return this;
        }

        @Override
        public FormInserter<String> with(MultiValueMap<String, String> values) {
            this.data.addAll(values);
            return this;
        }

        @Override
        public Mono<Void> insert(ClientHttpRequest outputMessage, BodyInserter.Context context) {
            HttpMessageWriter messageWriter = BodyInserters.findWriter(context, FORM_DATA_TYPE, MediaType.APPLICATION_FORM_URLENCODED);
            return messageWriter.write(Mono.just(this.data), FORM_DATA_TYPE, MediaType.APPLICATION_FORM_URLENCODED, outputMessage, context.hints());
        }
    }

    public static interface FormInserter<T>
    extends BodyInserter<MultiValueMap<String, T>, ClientHttpRequest> {
        public FormInserter<T> with(String var1, T var2);

        public FormInserter<T> with(MultiValueMap<String, T> var1);
    }

    private static class DefaultMultipartInserter
    implements MultipartInserter {
        private final MultipartBodyBuilder builder = new MultipartBodyBuilder();

        private DefaultMultipartInserter() {
        }

        public MultipartInserter with(String key, Object value) {
            this.builder.part(key, value);
            return this;
        }

        public MultipartInserter with(MultiValueMap<String, Object> values) {
            return this.withInternal(values);
        }

        private MultipartInserter withInternal(MultiValueMap<String, ?> values) {
            values.forEach((key, valueList) -> {
                for (Object value : valueList) {
                    this.builder.part((String)key, value);
                }
            });
            return this;
        }

        @Override
        public <T, P extends Publisher<T>> MultipartInserter withPublisher(String name, P publisher, Class<T> elementClass) {
            this.builder.asyncPart(name, publisher, elementClass);
            return this;
        }

        @Override
        public <T, P extends Publisher<T>> MultipartInserter withPublisher(String name, P publisher, ParameterizedTypeReference<T> typeReference) {
            this.builder.asyncPart(name, publisher, typeReference);
            return this;
        }

        @Override
        public Mono<Void> insert(ClientHttpRequest outputMessage, BodyInserter.Context context) {
            HttpMessageWriter messageWriter = BodyInserters.findWriter(context, MULTIPART_DATA_TYPE, MediaType.MULTIPART_FORM_DATA);
            MultiValueMap<String, HttpEntity<?>> body = this.builder.build();
            return messageWriter.write(Mono.just(body), MULTIPART_DATA_TYPE, MediaType.MULTIPART_FORM_DATA, outputMessage, context.hints());
        }
    }

    public static interface MultipartInserter
    extends FormInserter<Object> {
        public <T, P extends Publisher<T>> MultipartInserter withPublisher(String var1, P var2, Class<T> var3);

        public <T, P extends Publisher<T>> MultipartInserter withPublisher(String var1, P var2, ParameterizedTypeReference<T> var3);
    }
}

