/*
 * Decompiled with CFR 0.152.
 */
package infra.web.reactive.function;

import infra.core.ParameterizedTypeReference;
import infra.core.ResolvableType;
import infra.core.io.buffer.DataBuffer;
import infra.core.io.buffer.DataBufferUtils;
import infra.http.MediaType;
import infra.http.ReactiveHttpInputMessage;
import infra.http.client.reactive.ClientHttpResponse;
import infra.http.codec.HttpMessageReader;
import infra.http.codec.multipart.Part;
import infra.http.server.reactive.ServerHttpRequest;
import infra.http.server.reactive.ServerHttpResponse;
import infra.util.MultiValueMap;
import infra.web.reactive.function.BodyExtractor;
import infra.web.reactive.function.UnsupportedMediaTypeException;
import java.lang.reflect.Type;
import java.util.List;
import java.util.Optional;
import java.util.function.Function;
import java.util.function.Supplier;
import org.reactivestreams.Publisher;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;

public abstract class BodyExtractors {
    private static final ResolvableType FORM_DATA_TYPE = ResolvableType.forClassWithGenerics(MultiValueMap.class, (Class[])new Class[]{String.class, String.class});
    private static final ResolvableType MULTIPART_DATA_TYPE = ResolvableType.forClassWithGenerics(MultiValueMap.class, (Class[])new Class[]{String.class, Part.class});
    private static final ResolvableType PART_TYPE = ResolvableType.forClass(Part.class);
    private static final ResolvableType VOID_TYPE = ResolvableType.forClass(Void.class);

    public static <T> BodyExtractor<Mono<T>, ReactiveHttpInputMessage> toMono(Class<? extends T> elementClass) {
        return BodyExtractors.toMono(ResolvableType.forClass(elementClass));
    }

    public static <T> BodyExtractor<Mono<T>, ReactiveHttpInputMessage> toMono(ParameterizedTypeReference<T> elementTypeRef) {
        return BodyExtractors.toMono(ResolvableType.forType((Type)elementTypeRef.getType()));
    }

    private static <T> BodyExtractor<Mono<T>, ReactiveHttpInputMessage> toMono(ResolvableType elementType) {
        return (inputMessage, context) -> BodyExtractors.readWithMessageReaders(inputMessage, context, elementType, reader -> BodyExtractors.readToMono(inputMessage, context, elementType, reader), ex -> Mono.from(BodyExtractors.unsupportedErrorHandler(inputMessage, ex)), BodyExtractors.skipBodyAsMono(inputMessage));
    }

    public static <T> BodyExtractor<Flux<T>, ReactiveHttpInputMessage> toFlux(Class<? extends T> elementClass) {
        return BodyExtractors.toFlux(ResolvableType.forClass(elementClass));
    }

    public static <T> BodyExtractor<Flux<T>, ReactiveHttpInputMessage> toFlux(ParameterizedTypeReference<T> typeRef) {
        return BodyExtractors.toFlux(ResolvableType.forType((Type)typeRef.getType()));
    }

    private static <T> BodyExtractor<Flux<T>, ReactiveHttpInputMessage> toFlux(ResolvableType elementType) {
        return (inputMessage, context) -> BodyExtractors.readWithMessageReaders(inputMessage, context, elementType, reader -> BodyExtractors.readToFlux(inputMessage, context, elementType, reader), ex -> BodyExtractors.unsupportedErrorHandler(inputMessage, ex), BodyExtractors.skipBodyAsFlux(inputMessage));
    }

    public static BodyExtractor<Mono<MultiValueMap<String, String>>, ReactiveHttpInputMessage> toFormData() {
        return (message, context) -> {
            ResolvableType elementType = FORM_DATA_TYPE;
            MediaType mediaType = MediaType.APPLICATION_FORM_URLENCODED;
            HttpMessageReader reader = BodyExtractors.findReader(elementType, mediaType, context);
            return BodyExtractors.readToMono(message, context, elementType, reader);
        };
    }

    public static BodyExtractor<Mono<MultiValueMap<String, Part>>, ServerHttpRequest> toMultipartData() {
        return (serverRequest, context) -> {
            ResolvableType elementType = MULTIPART_DATA_TYPE;
            MediaType mediaType = MediaType.MULTIPART_FORM_DATA;
            HttpMessageReader reader = BodyExtractors.findReader(elementType, mediaType, context);
            return BodyExtractors.readToMono(serverRequest, context, elementType, reader);
        };
    }

    public static BodyExtractor<Flux<Part>, ServerHttpRequest> toParts() {
        return (serverRequest, context) -> {
            ResolvableType elementType = PART_TYPE;
            MediaType mediaType = MediaType.MULTIPART_FORM_DATA;
            HttpMessageReader reader = BodyExtractors.findReader(elementType, mediaType, context);
            return BodyExtractors.readToFlux(serverRequest, context, elementType, reader);
        };
    }

    public static BodyExtractor<Flux<DataBuffer>, ReactiveHttpInputMessage> toDataBuffers() {
        return (inputMessage, context) -> inputMessage.getBody();
    }

    private static <T, S extends Publisher<T>> S readWithMessageReaders(ReactiveHttpInputMessage message, BodyExtractor.Context context, ResolvableType elementType, Function<HttpMessageReader<T>, S> readerFunction, Function<UnsupportedMediaTypeException, S> errorFunction, Supplier<S> emptySupplier) {
        if (VOID_TYPE.equals((Object)elementType)) {
            return (S)((Publisher)emptySupplier.get());
        }
        MediaType contentType = Optional.ofNullable(message.getHeaders().getContentType()).orElse(MediaType.APPLICATION_OCTET_STREAM);
        for (HttpMessageReader<?> messageReader : context.messageReaders()) {
            if (!messageReader.canRead(elementType, contentType)) continue;
            return (S)((Publisher)readerFunction.apply(BodyExtractors.cast(messageReader)));
        }
        List<MediaType> mediaTypes = context.messageReaders().stream().flatMap(reader -> reader.getReadableMediaTypes(elementType).stream()).toList();
        return (S)((Publisher)errorFunction.apply(new UnsupportedMediaTypeException(contentType, mediaTypes, elementType)));
    }

    private static <T> Mono<T> readToMono(ReactiveHttpInputMessage message, BodyExtractor.Context context, ResolvableType type, HttpMessageReader<T> reader) {
        return context.serverResponse().map(response -> reader.readMono(type, type, (ServerHttpRequest)message, (ServerHttpResponse)response, context.hints())).orElseGet(() -> reader.readMono(type, message, context.hints()));
    }

    private static <T> Flux<T> readToFlux(ReactiveHttpInputMessage message, BodyExtractor.Context context, ResolvableType type, HttpMessageReader<T> reader) {
        return context.serverResponse().map(response -> reader.read(type, type, (ServerHttpRequest)message, (ServerHttpResponse)response, context.hints())).orElseGet(() -> reader.read(type, message, context.hints()));
    }

    private static <T> Flux<T> unsupportedErrorHandler(ReactiveHttpInputMessage message, UnsupportedMediaTypeException ex) {
        Flux result = message.getHeaders().getContentType() == null ? message.getBody().handle((buffer, sink) -> {
            DataBufferUtils.release((DataBuffer)buffer);
            sink.error((Throwable)((Object)ex));
        }) : (message instanceof ClientHttpResponse ? BodyExtractors.consumeAndCancel(message).thenMany((Publisher)Flux.error((Throwable)((Object)ex))) : Flux.error((Throwable)((Object)ex)));
        return result;
    }

    private static <T> HttpMessageReader<T> findReader(ResolvableType elementType, MediaType mediaType, BodyExtractor.Context context) {
        return context.messageReaders().stream().filter(messageReader -> messageReader.canRead(elementType, mediaType)).findFirst().map(BodyExtractors::cast).orElseThrow(() -> new IllegalStateException("No HttpMessageReader for \"" + mediaType + "\" and \"" + elementType + "\""));
    }

    private static <T> HttpMessageReader<T> cast(HttpMessageReader<?> reader) {
        return reader;
    }

    private static <T> Supplier<Flux<T>> skipBodyAsFlux(ReactiveHttpInputMessage message) {
        return message instanceof ClientHttpResponse ? () -> BodyExtractors.consumeAndCancel(message).thenMany((Publisher)Mono.empty()) : Flux::empty;
    }

    private static <T> Supplier<Mono<T>> skipBodyAsMono(ReactiveHttpInputMessage message) {
        return message instanceof ClientHttpResponse ? () -> BodyExtractors.consumeAndCancel(message).then(Mono.empty()) : Mono::empty;
    }

    private static Flux<DataBuffer> consumeAndCancel(ReactiveHttpInputMessage message) {
        return message.getBody().takeWhile(buffer -> {
            DataBufferUtils.release((DataBuffer)buffer);
            return false;
        });
    }
}

