/*
 * Decompiled with CFR 0.152.
 */
package infra.web.multipart.support;

import infra.beans.propertyeditors.ByteArrayPropertyEditor;
import infra.lang.Nullable;
import infra.web.multipart.MultipartFile;
import java.io.IOException;

public class ByteArrayMultipartFileEditor
extends ByteArrayPropertyEditor {
    public void setValue(@Nullable Object value) {
        if (value instanceof MultipartFile) {
            MultipartFile multipartFile = (MultipartFile)value;
            try {
                super.setValue((Object)multipartFile.getBytes());
            }
            catch (IOException ex) {
                throw new IllegalArgumentException("Cannot read contents of multipart file", ex);
            }
        } else if (value instanceof byte[]) {
            super.setValue(value);
        } else {
            super.setValue(value != null ? value.toString().getBytes() : null);
        }
    }

    public String getAsText() {
        byte[] value = (byte[])this.getValue();
        return value != null ? new String(value) : "";
    }
}

