/*
 * Decompiled with CFR 0.152.
 */
package infra.web.multipart.support;

import infra.lang.Nullable;
import infra.util.LinkedMultiValueMap;
import infra.util.MultiValueMap;
import infra.web.multipart.Multipart;
import infra.web.multipart.MultipartFile;
import infra.web.multipart.MultipartRequest;
import infra.web.util.WebUtils;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

public abstract class AbstractMultipartRequest
implements MultipartRequest {
    @Nullable
    private MultiValueMap<String, Multipart> parts;
    @Nullable
    private MultiValueMap<String, MultipartFile> multipartFiles;

    @Override
    public Iterator<String> getFileNames() {
        return this.getMultipartFiles().keySet().iterator();
    }

    @Override
    public MultipartFile getFile(String name) {
        return (MultipartFile)this.getMultipartFiles().getFirst((Object)name);
    }

    @Override
    public List<MultipartFile> getFiles(String name) {
        return (List)this.getMultipartFiles().get((Object)name);
    }

    @Override
    @Nullable
    public List<Multipart> multipartData(String name) {
        return (List)this.multipartData().get((Object)name);
    }

    @Override
    public Map<String, MultipartFile> getFileMap() {
        return this.getMultipartFiles().toSingleValueMap();
    }

    @Override
    public MultiValueMap<String, MultipartFile> getMultipartFiles() {
        LinkedMultiValueMap multipartFiles = this.multipartFiles;
        if (multipartFiles == null) {
            multipartFiles = MultiValueMap.forLinkedHashMap();
            for (Map.Entry entry : this.multipartData().entrySet()) {
                for (Multipart multipart : (List)entry.getValue()) {
                    if (multipart.isFormField()) continue;
                    multipartFiles.add((Object)((String)entry.getKey()), (Object)((MultipartFile)multipart));
                }
            }
            this.multipartFiles = multipartFiles;
        }
        return multipartFiles;
    }

    @Override
    public MultiValueMap<String, Multipart> multipartData() {
        MultiValueMap<String, Multipart> parts = this.parts;
        if (parts == null) {
            this.parts = parts = this.parseRequest();
        }
        return parts;
    }

    public boolean isResolved() {
        return this.parts != null;
    }

    @Override
    public void cleanup() {
        WebUtils.cleanupMultipartRequest(this.parts);
    }

    protected abstract MultiValueMap<String, Multipart> parseRequest();
}

