/*
 * Decompiled with CFR 0.152.
 */
package infra.web.multipart.support;

import infra.lang.Nullable;
import infra.util.ExceptionUtils;
import infra.web.multipart.MultipartFile;
import infra.web.multipart.support.AbstractMultipart;
import java.io.File;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;

public abstract class AbstractMultipartFile
extends AbstractMultipart
implements MultipartFile {
    @Nullable
    protected byte[] cachedBytes;

    @Override
    public void transferTo(File dest) throws IOException {
        File parentFile = dest.getParentFile();
        if (!parentFile.exists()) {
            parentFile.mkdirs();
        }
        if (dest.exists()) {
            Files.delete(dest.toPath());
        }
        this.saveInternal(dest);
    }

    protected abstract void saveInternal(File var1) throws IOException;

    @Override
    public byte[] getBytes() throws IOException {
        byte[] cachedBytes = this.cachedBytes;
        if (cachedBytes == null) {
            this.cachedBytes = cachedBytes = this.doGetBytes();
        }
        return cachedBytes;
    }

    protected abstract byte[] doGetBytes() throws IOException;

    @Override
    public final boolean isFormField() {
        return false;
    }

    @Override
    public String getValue() {
        try {
            return new String(this.getBytes(), StandardCharsets.UTF_8);
        }
        catch (IOException e) {
            throw ExceptionUtils.sneakyThrow((Throwable)e);
        }
    }

    @Override
    public final void cleanup() throws IOException {
        this.cachedBytes = null;
        this.deleteInternal();
    }

    protected abstract void deleteInternal() throws IOException;

    @Override
    public String toString() {
        return "%s: '%s'".formatted(this.getClass().getSimpleName(), this.getName());
    }
}

