/*
 * Decompiled with CFR 0.152.
 */
package infra.web.multipart.support;

import infra.http.DefaultHttpHeaders;
import infra.http.HttpHeaders;
import infra.lang.Nullable;
import infra.web.multipart.Multipart;

public abstract class AbstractMultipart
implements Multipart {
    @Nullable
    protected HttpHeaders headers;

    @Override
    public HttpHeaders getHeaders() {
        HttpHeaders headers = this.headers;
        if (headers == null) {
            this.headers = headers = this.createHttpHeaders();
        }
        return headers;
    }

    protected HttpHeaders createHttpHeaders() {
        DefaultHttpHeaders headers = HttpHeaders.forWritable();
        String contentType = this.getContentType();
        if (contentType != null) {
            headers.setOrRemove("Content-Type", contentType);
        }
        return headers;
    }

    public String toString() {
        return "%s: %s=%s".formatted(this.getClass().getSimpleName(), this.getName(), this.getValue());
    }
}

