/*
 * Decompiled with CFR 0.152.
 */
package infra.web.multipart;

import infra.core.io.AbstractResource;
import infra.lang.Assert;
import infra.lang.Nullable;
import infra.web.multipart.MultipartFile;
import java.io.IOException;
import java.io.InputStream;

class MultipartFileResource
extends AbstractResource {
    private final MultipartFile multipartFile;

    public MultipartFileResource(MultipartFile multipartFile) {
        Assert.notNull((Object)multipartFile, (String)"MultipartFile is required");
        this.multipartFile = multipartFile;
    }

    public boolean exists() {
        return true;
    }

    public boolean isOpen() {
        return true;
    }

    public long contentLength() {
        return this.multipartFile.getSize();
    }

    public String getName() {
        return this.multipartFile.getOriginalFilename();
    }

    public InputStream getInputStream() throws IOException, IllegalStateException {
        return this.multipartFile.getInputStream();
    }

    public String toString() {
        return "MultipartFile resource [%s]".formatted(this.multipartFile.getName());
    }

    public boolean equals(@Nullable Object other) {
        return this == other || other instanceof MultipartFileResource && ((MultipartFileResource)((Object)other)).multipartFile.equals(this.multipartFile);
    }

    public int hashCode() {
        return this.multipartFile.hashCode();
    }
}

