/*
 * Decompiled with CFR 0.152.
 */
package infra.web.multipart;

import infra.core.io.InputStreamSource;
import infra.core.io.Resource;
import infra.lang.Nullable;
import infra.web.multipart.Multipart;
import infra.web.multipart.MultipartFileResource;
import java.io.File;
import java.io.IOException;
import java.nio.channels.FileChannel;
import java.nio.file.Path;
import java.nio.file.StandardOpenOption;

public interface MultipartFile
extends Multipart,
InputStreamSource {
    @Override
    @Nullable
    public String getContentType();

    public long getSize();

    @Override
    public String getName();

    @Nullable
    public String getOriginalFilename();

    public boolean isEmpty();

    @Override
    public byte[] getBytes() throws IOException;

    public Object getOriginalResource();

    @Override
    public void cleanup() throws IOException;

    default public Resource getResource() {
        return new MultipartFileResource(this);
    }

    public void transferTo(File var1) throws IOException, IllegalStateException;

    default public void transferTo(Path dest) throws IOException, IllegalStateException {
        try (FileChannel channel = FileChannel.open(dest, StandardOpenOption.CREATE, StandardOpenOption.WRITE);){
            this.transferTo(channel, 0L, this.getSize());
        }
    }

    default public long transferTo(FileChannel out, long position, long count) throws IOException {
        return out.transferFrom(this.readableChannel(), position, count);
    }
}

