/*
 * Decompiled with CFR 0.152.
 */
package infra.web.multipart;

import infra.http.HttpStatus;
import infra.http.HttpStatusCode;
import infra.http.ProblemDetail;
import infra.lang.Nullable;
import infra.web.ErrorResponse;
import infra.web.bind.MultipartException;

public class MaxUploadSizeExceededException
extends MultipartException
implements ErrorResponse {
    private final ProblemDetail body = ProblemDetail.forStatusAndDetail(HttpStatus.PAYLOAD_TOO_LARGE, "Maximum upload size exceeded");
    private final long maxUploadSize;

    public MaxUploadSizeExceededException(long maxUploadSize) {
        this(maxUploadSize, null);
    }

    public MaxUploadSizeExceededException(long maxUploadSize, @Nullable Throwable ex) {
        super("Maximum upload size %sexceeded".formatted(maxUploadSize >= 0L ? "of %d bytes ".formatted(maxUploadSize) : ""), ex);
        this.maxUploadSize = maxUploadSize;
    }

    public long getMaxUploadSize() {
        return this.maxUploadSize;
    }

    @Override
    public HttpStatusCode getStatusCode() {
        return HttpStatus.PAYLOAD_TOO_LARGE;
    }

    @Override
    public ProblemDetail getBody() {
        return this.body;
    }
}

